/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;

public class BranchCoverageMap
implements SearchListener<TestSuiteChromosome> {
    private static final long serialVersionUID = -3498997999289782541L;
    public static BranchCoverageMap instance = null;
    private Map<Integer, TestCase> coveredTrueBranches;
    private Map<Integer, TestCase> coveredFalseBranches;

    private BranchCoverageMap() {
    }

    public static BranchCoverageMap getInstance() {
        if (instance == null) {
            instance = new BranchCoverageMap();
        }
        return instance;
    }

    public boolean isCoveredTrue(int branchId) {
        return this.coveredTrueBranches.containsKey(branchId);
    }

    public boolean isCoveredFalse(int branchId) {
        return this.coveredFalseBranches.containsKey(branchId);
    }

    public TestCase getTestCoveringTrue(int branchId) {
        return this.coveredTrueBranches.get(branchId);
    }

    public TestCase getTestCoveringFalse(int branchId) {
        return this.coveredFalseBranches.get(branchId);
    }

    public Set<Integer> getCoveredTrueBranches() {
        return this.coveredTrueBranches.keySet();
    }

    public Set<Integer> getCoveredFalseBranches() {
        return this.coveredFalseBranches.keySet();
    }

    @Override
    public void searchStarted(GeneticAlgorithm<TestSuiteChromosome> algorithm) {
        this.coveredTrueBranches = new LinkedHashMap<Integer, TestCase>();
        this.coveredFalseBranches = new LinkedHashMap<Integer, TestCase>();
    }

    @Override
    public void iteration(GeneticAlgorithm<TestSuiteChromosome> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<TestSuiteChromosome> algorithm) {
        this.coveredTrueBranches = null;
        this.coveredFalseBranches = null;
    }

    @Override
    public void fitnessEvaluation(TestSuiteChromosome suite) {
        if (suite == null) {
            return;
        }
        for (TestChromosome testChromosome : suite.getTestChromosomes()) {
            ExecutionResult lastResult = testChromosome.getLastExecutionResult();
            if (lastResult == null) continue;
            for (int branchId : lastResult.getTrace().getCoveredTrueBranches()) {
                if (this.coveredTrueBranches.containsKey(branchId)) continue;
                this.coveredTrueBranches.put(branchId, testChromosome.getTestCase());
            }
            for (int branchId : lastResult.getTrace().getCoveredFalseBranches()) {
                if (this.coveredFalseBranches.containsKey(branchId)) continue;
                this.coveredFalseBranches.put(branchId, testChromosome.getTestCase());
            }
        }
    }

    @Override
    public void modification(TestSuiteChromosome individual) {
    }
}

