/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.List;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterLocalSearch
extends StatementLocalSearch {
    private static final Logger logger = LoggerFactory.getLogger(ParameterLocalSearch.class);
    private ExecutionResult oldResult;
    private boolean oldChanged;

    private void backup(ExecutableChromosome test, Statement p) {
        this.oldResult = test.getLastExecutionResult();
        this.oldChanged = test.isChanged();
    }

    private void restore(ExecutableChromosome test, Statement p) {
        test.setLastExecutionResult(this.oldResult);
        test.setChanged(this.oldChanged);
    }

    @Override
    public boolean doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        Statement stmt = test.getTestCase().getStatement(statement);
        this.backup(test, stmt);
        if (stmt instanceof MethodStatement) {
            return this.doSearch(test, (MethodStatement)stmt, objective);
        }
        if (stmt instanceof ConstructorStatement) {
            return this.doSearch(test, (ConstructorStatement)stmt, objective);
        }
        if (stmt instanceof FieldStatement) {
            return this.doSearch(test, (FieldStatement)stmt, objective);
        }
        return false;
    }

    private boolean doSearch(TestChromosome test, MethodStatement statement, LocalSearchObjective<TestChromosome> objective) {
        logger.info("Original test: " + test.getTestCase().toCode());
        boolean hasImproved = false;
        if (!statement.isStatic()) {
            logger.info("Replacing callee");
            VariableReference callee = statement.getCallee();
            List<VariableReference> objects = test.getTestCase().getObjects(callee.getType(), statement.getPosition());
            objects.remove(callee);
            boolean done = false;
            for (VariableReference replacement : objects) {
                statement.setCallee(replacement);
                if (objective.hasImproved(test)) {
                    done = true;
                    hasImproved = true;
                    this.backup(test, statement);
                    break;
                }
                logger.info("Undoing change");
                this.restore(test, statement);
            }
            if (!done) {
                statement.setCallee(callee);
            }
        }
        int numParameter = 0;
        for (VariableReference parameter : statement.getParameterReferences()) {
            logger.info("Replacing parameter " + numParameter);
            statement.replaceParameterReference(new NullReference(test.getTestCase(), parameter.getType()), numParameter);
            logger.info("Resulting test: " + test.getTestCase().toCode());
            if (!objective.hasImproved(test)) {
                logger.info("Undoing change");
                this.restore(test, statement);
                statement.replaceParameterReference(parameter, numParameter);
                boolean done = false;
                List<VariableReference> objects = test.getTestCase().getObjects(parameter.getType(), statement.getPosition());
                objects.remove(parameter);
                for (VariableReference replacement : objects) {
                    statement.replaceParameterReference(replacement, numParameter);
                    logger.info("Resulting test: " + test.getTestCase().toCode());
                    if (objective.hasImproved(test)) {
                        this.backup(test, statement);
                        hasImproved = true;
                        done = true;
                        break;
                    }
                    logger.info("Undoing change");
                    this.restore(test, statement);
                }
                if (!done) {
                    statement.replaceParameterReference(parameter, numParameter);
                }
            } else {
                hasImproved = true;
            }
            ++numParameter;
        }
        return hasImproved;
    }

    private boolean doSearch(TestChromosome test, ConstructorStatement statement, LocalSearchObjective<TestChromosome> objective) {
        int numParameter = 0;
        boolean hasImproved = false;
        for (VariableReference parameter : statement.getParameterReferences()) {
            statement.replaceParameterReference(new NullReference(test.getTestCase(), parameter.getType()), numParameter);
            if (!objective.hasImproved(test)) {
                statement.replaceParameterReference(parameter, numParameter);
                boolean done = false;
                List<VariableReference> objects = test.getTestCase().getObjects(parameter.getType(), statement.getPosition());
                objects.remove(parameter);
                for (VariableReference replacement : objects) {
                    statement.replaceParameterReference(replacement, numParameter);
                    if (!objective.hasImproved(test)) continue;
                    done = true;
                    hasImproved = true;
                    break;
                }
                if (!done) {
                    statement.replaceParameterReference(parameter, numParameter);
                }
            } else {
                hasImproved = true;
            }
            ++numParameter;
        }
        return hasImproved;
    }

    private boolean doSearch(TestChromosome test, FieldStatement statement, LocalSearchObjective<TestChromosome> objective) {
        if (!statement.isStatic()) {
            VariableReference source = statement.getSource();
            List<VariableReference> objects = test.getTestCase().getObjects(source.getType(), statement.getPosition());
            objects.remove(source);
            for (VariableReference replacement : objects) {
                statement.setSource(replacement);
                if (!objective.hasImproved(test)) continue;
                return true;
            }
            statement.setSource(source);
        }
        return false;
    }
}

