/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.localsearch.LocalSearch;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.localsearch.AVMTestCaseLocalSearch;
import org.evosuite.testcase.localsearch.DSETestCaseLocalSearch;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestCaseLocalSearch<T extends Chromosome<T>>
implements LocalSearch<T> {
    protected static final Logger logger = LoggerFactory.getLogger(TestCaseLocalSearch.class);

    public static TestCaseLocalSearch<TestChromosome> selectTestCaseLocalSearch() {
        boolean useDSE;
        double nextDouble = Randomness.nextDouble();
        boolean bl = useDSE = nextDouble < Properties.DSE_PROBABILITY;
        if (useDSE) {
            return new DSETestCaseLocalSearch();
        }
        return new AVMTestCaseLocalSearch();
    }

    public static void randomizePrimitives(TestCase test) {
        for (Statement s : test) {
            if (!(s instanceof PrimitiveStatement) || s instanceof NullStatement) continue;
            ((PrimitiveStatement)s).randomize();
        }
    }
}

