/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.PrintStream;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.runtime.FalsePositiveException;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.instrumentation.InstrumentedClass;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.shaded.org.mockito.MockSettings;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.stubbing.OngoingStubbing;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.UncompilableCodeException;
import org.evosuite.testcase.fm.EvoInvocationListener;
import org.evosuite.testcase.fm.MethodDescriptor;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionalMockStatement
extends EntityWithParametersStatement {
    private static final long serialVersionUID = -8177814473724093381L;
    private static final Logger logger = LoggerFactory.getLogger(FunctionalMockStatement.class);
    protected final List<MethodDescriptor> mockedMethods;
    protected final Map<String, int[]> methodParameters;
    protected GenericClass targetClass;
    protected volatile transient EvoInvocationListener listener;
    protected transient Method mockCreator;

    public FunctionalMockStatement(TestCase tc, VariableReference retval, GenericClass targetClass) throws IllegalArgumentException {
        super(tc, retval);
        Inputs.checkNull(targetClass);
        this.targetClass = targetClass;
        this.mockedMethods = new ArrayList<MethodDescriptor>();
        this.methodParameters = new LinkedHashMap<String, int[]>();
        this.checkTarget();
        assert (this.parameters.isEmpty());
    }

    public FunctionalMockStatement(TestCase tc, Type retvalType, GenericClass targetClass) throws IllegalArgumentException {
        super(tc, retvalType);
        Inputs.checkNull(targetClass);
        Class<?> rawType = new GenericClass(retvalType).getRawClass();
        if (!targetClass.getRawClass().equals(rawType)) {
            throw new IllegalArgumentException("Mismatch between raw type " + rawType + " and target class " + targetClass);
        }
        this.targetClass = targetClass;
        this.mockedMethods = new ArrayList<MethodDescriptor>();
        this.methodParameters = new LinkedHashMap<String, int[]>();
        this.checkTarget();
        assert (this.parameters.isEmpty());
    }

    private void setUpMockCreator() {
        ClassLoader loader = this.targetClass.getRawClass().getClassLoader();
        try {
            Class<?> mockito = loader.loadClass(Mockito.class.getName());
            this.mockCreator = mockito.getDeclaredMethod("mock", loader.loadClass(Class.class.getName()), loader.loadClass(MockSettings.class.getName()));
        }
        catch (Exception e) {
            logger.error("Failed to setup mock creator: " + e.getMessage());
        }
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.targetClass.changeClassLoader(loader);
        for (MethodDescriptor descriptor : this.mockedMethods) {
            if (descriptor == null) continue;
            descriptor.changeClassLoader(loader);
        }
        if (this.listener != null) {
            this.listener.changeClassLoader(loader);
        }
        super.changeClassLoader(loader);
    }

    protected void checkTarget() {
        if (!FunctionalMockStatement.canBeFunctionalMocked(this.targetClass.getRawClass())) {
            throw new IllegalArgumentException("Cannot create a basic functional mock for class " + this.targetClass);
        }
    }

    public static boolean canBeFunctionalMockedIncludingSUT(Type type) {
        Class<?> rawClass = new GenericClass(type).getRawClass();
        if (EvoSuiteMock.class.isAssignableFrom(rawClass) || MockList.isAMockClass(rawClass.getName()) || rawClass.equals(Class.class) || rawClass.isArray() || rawClass.isPrimitive() || rawClass.isAnonymousClass() || rawClass.isEnum() || !Modifier.isPublic(rawClass.getModifiers())) {
            return false;
        }
        if (!InstrumentedClass.class.isAssignableFrom(rawClass) && Modifier.isFinal(rawClass.getModifiers())) {
            return false;
        }
        if (InetSocketAddress.class.equals(rawClass)) {
            return false;
        }
        try {
            rawClass.getDeclaredMethods();
        }
        catch (NoClassDefFoundError e) {
            AtMostOnceLogger.warn(logger, "Problem with class " + rawClass.getName() + ": " + e.toString());
            return false;
        }
        boolean onlySelfReturns = true;
        for (Method m : rawClass.getDeclaredMethods()) {
            if (rawClass.equals(m.getReturnType())) continue;
            onlySelfReturns = false;
            break;
        }
        if (onlySelfReturns && rawClass.getDeclaredMethods().length > 0) {
            return false;
        }
        List<Class> avoid = Arrays.asList(new Class[0]);
        return !avoid.contains(rawClass);
    }

    public static boolean canBeFunctionalMocked(Type type) {
        Class<?> rawClass = new GenericClass(type).getRawClass();
        Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
        if (Properties.hasTargetClassBeenLoaded() && GenericClass.isAssignable(targetClass, rawClass)) {
            return false;
        }
        return FunctionalMockStatement.canBeFunctionalMockedIncludingSUT(type);
    }

    public Class<?> getTargetClass() {
        return this.targetClass.getRawClass();
    }

    public List<MethodDescriptor> getMockedMethods() {
        return this.mockedMethods;
    }

    public List<VariableReference> getParameters(String id) throws IllegalArgumentException {
        Inputs.checkNull(id);
        int[] minMax = this.methodParameters.get(id);
        if (minMax == null) {
            return null;
        }
        ArrayList<VariableReference> list = new ArrayList<VariableReference>();
        for (int i = minMax[0]; i <= minMax[1]; ++i) {
            list.add((VariableReference)this.parameters.get(i));
        }
        return list;
    }

    public boolean doesNeedToUpdateInputs() {
        if (this.listener == null) {
            assert (this.mockedMethods.isEmpty() || RuntimeSettings.isRunningASystemTest);
            return false;
        }
        List<MethodDescriptor> executed = this.listener.getCopyOfMethodDescriptors();
        if (executed.size() != this.mockedMethods.size()) {
            return true;
        }
        for (int i = 0; i < executed.size(); ++i) {
            MethodDescriptor previous = this.mockedMethods.get(i);
            MethodDescriptor now = executed.get(i);
            if (!previous.getID().equals(now.getID())) {
                return true;
            }
            if (!now.shouldBeMocked() || (now.getCounter() == previous.getCounter() || now.getCounter() >= Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT) && previous.getCounter() >= Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT) continue;
            return true;
        }
        return false;
    }

    public List<Type> updateMockedMethods() throws ConstructionFailedException {
        logger.debug("Executing updateMockedMethods. Parameter size: " + this.parameters.size());
        ArrayList<Type> list = new ArrayList<Type>();
        assert (!this.parameters.contains(null));
        assert (this.mockedMethods.size() == this.methodParameters.size());
        ArrayList<VariableReference> copy = new ArrayList<VariableReference>(this.parameters);
        assert (copy.size() == this.parameters.size());
        this.parameters.clear();
        this.mockedMethods.clear();
        LinkedHashMap<String, int[]> mpCopy = new LinkedHashMap<String, int[]>();
        List<MethodDescriptor> executed = this.listener.getCopyOfMethodDescriptors();
        int mdIndex = 0;
        for (MethodDescriptor md : executed) {
            int i;
            int existingParameters;
            this.mockedMethods.add(md);
            if (!md.shouldBeMocked() || md.getCounter() == 0) {
                mpCopy.put(md.getID(), null);
                continue;
            }
            int added = 0;
            logger.debug("Method called on mock object: " + md.getMethod());
            int[] minMax = this.methodParameters.get(md.getID());
            if (minMax == null) {
                minMax = new int[]{-1, -1};
                existingParameters = 0;
            } else {
                assert (minMax[1] >= minMax[0] && minMax[0] >= 0);
                assert (minMax[1] < copy.size()) : "Max=" + minMax[1] + " but n=" + copy.size();
                existingParameters = 1 + (minMax[1] - minMax[0]);
            }
            assert (existingParameters <= Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT);
            if (existingParameters > md.getCounter()) {
                minMax[1] = minMax[1] - (existingParameters - md.getCounter());
            }
            if (existingParameters > 0) {
                for (i = minMax[0]; i <= minMax[1]; ++i) {
                    this.parameters.add((VariableReference)copy.get(i));
                    ++added;
                }
            }
            if (existingParameters < md.getCounter()) {
                for (i = existingParameters; i < md.getCounter() && i < Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT; ++i) {
                    GenericClass calleeClass = new GenericClass(this.retval.getGenericClass());
                    Type returnType = md.getGenericMethodFor(calleeClass).getGeneratedType();
                    assert (!returnType.equals(Void.TYPE));
                    logger.debug("Return type: " + returnType + " for retval " + this.retval.getGenericClass());
                    list.add(returnType);
                    this.parameters.add(null);
                    ++added;
                }
            }
            minMax[0] = mdIndex;
            minMax[1] = mdIndex + added - 1;
            assert (minMax[1] >= minMax[0] && minMax[0] >= 0);
            assert (this.parameters.size() == minMax[1] + 1);
            mpCopy.put(md.getID(), minMax);
            mdIndex += added;
        }
        this.methodParameters.clear();
        this.methodParameters.putAll(mpCopy);
        for (MethodDescriptor md : this.mockedMethods) {
            if (this.methodParameters.containsKey(md.getID())) continue;
            this.methodParameters.put(md.getID(), null);
        }
        return list;
    }

    public void addMissingInputs(List<VariableReference> inputs) throws IllegalArgumentException {
        Inputs.checkNull(inputs);
        logger.debug("Adding {} missing values", (Object)inputs.size());
        if (!inputs.isEmpty()) {
            if (inputs.size() > this.parameters.size()) {
                throw new IllegalArgumentException("Not enough parameter place holders");
            }
            int index = 0;
            for (VariableReference ref : inputs) {
                while (this.parameters.get(index) != null) {
                    if (++index < this.parameters.size()) continue;
                    throw new IllegalArgumentException("Not enough parameter place holders");
                }
                logger.debug("Current input: " + ref + " for expected type " + this.getExpectedParameterType(index));
                assert (ref.isAssignableTo(this.getExpectedParameterType(index)));
                this.parameters.set(index, ref);
            }
        }
        for (VariableReference ref : this.parameters) {
            if (ref != null) continue;
            throw new IllegalArgumentException("Functional mock not fully set with all needed missing inputs");
        }
    }

    public void fillWithNullRefs() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            VariableReference ref = (VariableReference)this.parameters.get(i);
            if (ref != null) continue;
            Class<?> expected = this.getExpectedParameterType(i);
            Constable value = null;
            if (expected.isPrimitive()) {
                if (expected.equals(Integer.TYPE)) {
                    value = 0;
                } else if (expected.equals(Float.TYPE)) {
                    value = Float.valueOf(0.0f);
                } else if (expected.equals(Double.TYPE)) {
                    value = 0.0;
                } else if (expected.equals(Long.TYPE)) {
                    value = 0L;
                } else if (expected.equals(Boolean.TYPE)) {
                    value = Boolean.valueOf(false);
                } else if (expected.equals(Short.TYPE)) {
                    value = Short.valueOf("0");
                } else if (expected.equals(Character.TYPE)) {
                    value = Character.valueOf('a');
                }
            }
            this.parameters.set(i, new ConstantValue(this.tc, new GenericClass(expected), value));
        }
    }

    private Class<?> getExpectedParameterType(int i) {
        for (MethodDescriptor md : this.mockedMethods) {
            int[] bounds = this.methodParameters.get(md.getID());
            if (bounds == null || i < bounds[0] || i > bounds[1]) continue;
            return md.getMethod().getReturnType();
        }
        throw new AssertionError((Object)"");
    }

    @Override
    public void addAssertion(Assertion assertion) {
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        FunctionalMockStatement copy = new FunctionalMockStatement(newTestCase, this.retval.getType(), this.targetClass);
        for (VariableReference variableReference : this.parameters) {
            copy.parameters.add(variableReference.copy(newTestCase, offset));
        }
        copy.listener = this.listener;
        for (MethodDescriptor methodDescriptor : this.mockedMethods) {
            copy.mockedMethods.add(methodDescriptor.getCopy());
        }
        for (Map.Entry entry : this.methodParameters.entrySet()) {
            int[] nArray;
            int[] array = (int[])entry.getValue();
            if (array == null) {
                nArray = null;
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = array[0];
                nArray = nArray2;
                nArray2[1] = array[1];
            }
            int[] copiedArray = nArray;
            copy.methodParameters.put((String)entry.getKey(), copiedArray);
        }
        return copy;
    }

    protected EvoInvocationListener createInvocationListener() {
        return new EvoInvocationListener(this.retval.getGenericClass());
    }

    protected MockSettings createMockSettings() {
        return Mockito.withSettings().invocationListeners(this.listener);
    }

    @Override
    public Throwable execute(final Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        Throwable exceptionThrown = null;
        try {
            return super.exceptionHandler(new AbstractStatement.Executer(){

                @Override
                public void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException {
                    Object ret;
                    FunctionalMockStatement.this.listener = FunctionalMockStatement.this.createInvocationListener();
                    try {
                        logger.debug("Mockito: create mock for {}", (Object)FunctionalMockStatement.this.targetClass);
                        ret = Mockito.mock(FunctionalMockStatement.this.targetClass.getRawClass(), FunctionalMockStatement.this.createMockSettings());
                        int index = 0;
                        logger.debug("Mockito: going to mock {} different methods", (Object)FunctionalMockStatement.this.mockedMethods.size());
                        for (MethodDescriptor md : FunctionalMockStatement.this.mockedMethods) {
                            Object targetMethodResult;
                            if (!md.shouldBeMocked()) {
                                logger.debug("Mockito: method {} cannot be mocked", (Object)md.getMethodName());
                                continue;
                            }
                            Method method = md.getMethod();
                            method.setAccessible(true);
                            Object[] targetInputs = new Object[md.getNumberOfInputParameters()];
                            for (int i = 0; i < targetInputs.length; ++i) {
                                logger.debug("Mockito: executing matcher {}/{}", (Object)(1 + i), (Object)targetInputs.length);
                                targetInputs[i] = md.executeMatcher(i);
                            }
                            logger.debug("Mockito: going to invoke method {} with {} matchers", (Object)method.getName(), (Object)targetInputs.length);
                            if (!method.getDeclaringClass().isAssignableFrom(ret.getClass())) {
                                String msg = "Mismatch between callee's class " + ret.getClass() + " and method's class " + method.getDeclaringClass();
                                msg = msg + "\nTarget class classloader " + FunctionalMockStatement.this.targetClass.getRawClass().getClassLoader() + " vs method's classloader " + method.getDeclaringClass().getClassLoader();
                                throw new EvosuiteError(msg);
                            }
                            try {
                                targetMethodResult = targetInputs.length == 0 ? method.invoke(ret, new Object[0]) : method.invoke(ret, targetInputs);
                            }
                            catch (InvocationTargetException e) {
                                logger.error("Invocation of mocked {}.{}() threw an exception. This means the method was not mocked", (Object)FunctionalMockStatement.this.targetClass.getClassName(), (Object)method.getName());
                                throw e;
                            }
                            catch (IllegalAccessError | IllegalArgumentException e) {
                                logger.error("IAE on <" + method + "> when called with " + Arrays.toString(targetInputs));
                                throw new CodeUnderTestException(e);
                            }
                            logger.debug("Mockito: call 'when'");
                            OngoingStubbing<Object> retForThen = Mockito.when(targetMethodResult);
                            Object[] thenReturnInputs = null;
                            try {
                                int size = Math.min(md.getCounter(), Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT);
                                thenReturnInputs = new Object[size];
                                for (int i = 0; i < thenReturnInputs.length; ++i) {
                                    int k = i + index;
                                    if (k >= FunctionalMockStatement.this.parameters.size()) {
                                        throw new CodeUnderTestException(new FalsePositiveException("EvoSuite ERROR: index " + k + " out of " + FunctionalMockStatement.this.parameters.size()));
                                    }
                                    VariableReference parameterVar = (VariableReference)FunctionalMockStatement.this.parameters.get(i + index);
                                    thenReturnInputs[i] = parameterVar.getObject(scope);
                                    CodeUnderTestException codeUnderTestException = null;
                                    if (thenReturnInputs[i] == null && method.getReturnType().isPrimitive()) {
                                        codeUnderTestException = new CodeUnderTestException(new NullPointerException());
                                    } else if (thenReturnInputs[i] != null && !TypeUtils.isAssignable(thenReturnInputs[i].getClass(), method.getReturnType())) {
                                        codeUnderTestException = new CodeUnderTestException(new UncompilableCodeException("Cannot assign " + parameterVar.getVariableClass().getName() + " to " + method.getReturnType()));
                                    }
                                    if (codeUnderTestException != null) {
                                        throw codeUnderTestException;
                                    }
                                    thenReturnInputs[i] = this.fixBoxing(thenReturnInputs[i], method.getReturnType());
                                }
                            }
                            catch (Exception e) {
                                retForThen.thenThrow(new RuntimeException("Failed to setup mock: " + e.getMessage()));
                                throw e;
                            }
                            logger.debug("Mockito: executing 'thenReturn'");
                            if (thenReturnInputs == null || thenReturnInputs.length == 0) {
                                retForThen.thenThrow(new RuntimeException("No valid return value"));
                            } else if (thenReturnInputs.length == 1) {
                                retForThen.thenReturn(thenReturnInputs[0]);
                            } else {
                                Object[] values = Arrays.copyOfRange(thenReturnInputs, 1, thenReturnInputs.length);
                                retForThen.thenReturn(thenReturnInputs[0], (Object[])values);
                            }
                            index += thenReturnInputs == null ? 0 : thenReturnInputs.length;
                        }
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (NoClassDefFoundError e) {
                        AtMostOnceLogger.error(logger, "Cannot use Mockito on " + FunctionalMockStatement.this.targetClass + " due to failed class initialization: " + e.getMessage());
                        return;
                    }
                    catch (IllegalAccessError | IllegalAccessException | IllegalArgumentException | MockitoException e) {
                        AtMostOnceLogger.error(logger, "Cannot use Mockito on " + FunctionalMockStatement.this.targetClass + " due to IAE: " + e.getMessage());
                        throw new CodeUnderTestException(e);
                    }
                    catch (Throwable t) {
                        AtMostOnceLogger.error(logger, "Failed to use Mockito on " + FunctionalMockStatement.this.targetClass + ": " + t.getMessage());
                        throw new EvosuiteError(t);
                    }
                    FunctionalMockStatement.this.listener.activate();
                    try {
                        FunctionalMockStatement.this.retval.setObject(scope, ret);
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new EvosuiteError(e);
                    }
                }

                private Object fixBoxing(Object value, Class<?> expectedType) {
                    if (!expectedType.isPrimitive()) {
                        return value;
                    }
                    Class<?> valuesClass = value.getClass();
                    assert (!valuesClass.isPrimitive());
                    if (expectedType.equals(Integer.TYPE)) {
                        if (valuesClass.equals(Character.class)) {
                            value = (int)((Character)value).charValue();
                        } else if (valuesClass.equals(Byte.class)) {
                            value = ((Byte)value).intValue();
                        } else if (valuesClass.equals(Short.class)) {
                            value = ((Short)value).intValue();
                        }
                    }
                    if (expectedType.equals(Double.TYPE)) {
                        if (valuesClass.equals(Integer.class)) {
                            value = (double)((Integer)value).intValue();
                        } else if (valuesClass.equals(Byte.class)) {
                            value = (double)((Byte)value).intValue();
                        } else if (valuesClass.equals(Character.class)) {
                            value = (double)((Character)value).charValue();
                        } else if (valuesClass.equals(Short.class)) {
                            value = (double)((Short)value).intValue();
                        } else if (valuesClass.equals(Long.class)) {
                            value = (double)((Long)value).longValue();
                        } else if (valuesClass.equals(Float.class)) {
                            value = (double)((Float)value).floatValue();
                        }
                    }
                    if (expectedType.equals(Float.TYPE)) {
                        if (valuesClass.equals(Integer.class)) {
                            value = Float.valueOf(((Integer)value).intValue());
                        } else if (valuesClass.equals(Byte.class)) {
                            value = Float.valueOf(((Byte)value).intValue());
                        } else if (valuesClass.equals(Character.class)) {
                            value = Float.valueOf(((Character)value).charValue());
                        } else if (valuesClass.equals(Short.class)) {
                            value = Float.valueOf(((Short)value).intValue());
                        } else if (valuesClass.equals(Long.class)) {
                            value = Float.valueOf(((Long)value).longValue());
                        }
                    }
                    if (expectedType.equals(Long.TYPE)) {
                        if (valuesClass.equals(Integer.class)) {
                            value = (long)((Integer)value).intValue();
                        } else if (valuesClass.equals(Byte.class)) {
                            value = (long)((Byte)value).intValue();
                        } else if (valuesClass.equals(Character.class)) {
                            value = (long)((Character)value).charValue();
                        } else if (valuesClass.equals(Short.class)) {
                            value = (long)((Short)value).intValue();
                        }
                    }
                    if (expectedType.equals(Short.TYPE)) {
                        if (valuesClass.equals(Integer.class)) {
                            value = (short)((Integer)value).intValue();
                        } else if (valuesClass.equals(Byte.class)) {
                            value = (short)((Byte)value).intValue();
                        } else if (valuesClass.equals(Short.class)) {
                            value = (short)((Short)value).intValue();
                        } else if (valuesClass.equals(Character.class)) {
                            value = (short)((Character)value).charValue();
                        } else if (valuesClass.equals(Long.class)) {
                            value = (short)((Long)value).intValue();
                        }
                    }
                    if (expectedType.equals(Byte.TYPE)) {
                        if (valuesClass.equals(Integer.class)) {
                            value = (byte)((Integer)value).intValue();
                        } else if (valuesClass.equals(Short.class)) {
                            value = (byte)((Short)value).intValue();
                        } else if (valuesClass.equals(Byte.class)) {
                            value = (byte)((Byte)value).intValue();
                        } else if (valuesClass.equals(Character.class)) {
                            value = (byte)((Character)value).charValue();
                        } else if (valuesClass.equals(Long.class)) {
                            value = (byte)((Long)value).intValue();
                        }
                    }
                    return value;
                }

                @Override
                public Set<Class<? extends Throwable>> throwableExceptions() {
                    LinkedHashSet<Class<? extends Throwable>> t = new LinkedHashSet<Class<? extends Throwable>>();
                    t.add(InvocationTargetException.class);
                    return t;
                }
            });
        }
        catch (InvocationTargetException e) {
            exceptionThrown = e.getCause();
            return exceptionThrown;
        }
    }

    @Override
    public GenericAccessibleObject<?> getAccessibleObject() {
        return null;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public boolean same(Statement s) {
        int i;
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        FunctionalMockStatement fms = (FunctionalMockStatement)s;
        if (fms.parameters.size() != this.parameters.size()) {
            return false;
        }
        for (i = 0; i < this.parameters.size(); ++i) {
            if (((VariableReference)this.parameters.get(i)).same((VariableReference)fms.parameters.get(i))) continue;
            return false;
        }
        if (!this.retval.same(fms.retval)) {
            return false;
        }
        if (!this.targetClass.equals(fms.targetClass)) {
            return false;
        }
        if (fms.mockedMethods.size() != this.mockedMethods.size()) {
            return false;
        }
        for (i = 0; i < this.mockedMethods.size(); ++i) {
            if (this.mockedMethods.get(i).getID().equals(fms.mockedMethods.get(i).getID())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "mock(" + this.retval.getType() + ")";
    }

    @Override
    public String getDescriptor() {
        return "()L" + PackageInfo.getNameWithSlash(this.retval.getVariableClass()) + ";";
    }

    @Override
    public String getDeclaringClassName() {
        return this.retval.getClassName();
    }

    @Override
    public String getMethodName() {
        return "mock";
    }
}

