/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.environment;

import org.evosuite.runtime.testdata.EnvironmentDataList;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.EvoSuiteRemoteAddress;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.environment.FileNamePrimitiveStatement;
import org.evosuite.testcase.statements.environment.LocalAddressPrimitiveStatement;
import org.evosuite.testcase.statements.environment.RemoteAddressPrimitiveStatement;
import org.evosuite.testcase.statements.environment.UrlPrimitiveStatement;
import org.evosuite.utils.Randomness;

public class EnvironmentStatements {
    public static boolean isEnvironmentData(Class<?> clazz) {
        for (Class<?> env : EnvironmentDataList.getListOfClasses()) {
            if (!clazz.equals(env)) continue;
            return true;
        }
        return false;
    }

    public static PrimitiveStatement<?> getStatement(Class<?> clazz, TestCase tc) throws IllegalArgumentException {
        if (!EnvironmentStatements.isEnvironmentData(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not an environment data type");
        }
        if (clazz.equals(EvoSuiteFile.class)) {
            return new FileNamePrimitiveStatement(tc, new EvoSuiteFile(Randomness.choice(tc.getAccessedEnvironment().getViewOfAccessedFiles())));
        }
        if (clazz.equals(EvoSuiteLocalAddress.class)) {
            return new LocalAddressPrimitiveStatement(tc);
        }
        if (clazz.equals(EvoSuiteRemoteAddress.class)) {
            return new RemoteAddressPrimitiveStatement(tc);
        }
        if (clazz.equals(EvoSuiteURL.class)) {
            return new UrlPrimitiveStatement(tc);
        }
        throw new RuntimeException("EvoSuite bug: unhandled class " + clazz.getName());
    }
}

