/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.environment;

import java.lang.reflect.Type;
import org.evosuite.runtime.testdata.EvoSuiteAddress;
import org.evosuite.runtime.testdata.EvoSuiteRemoteAddress;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.environment.EnvironmentDataStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.StringUtil;

public class RemoteAddressPrimitiveStatement
extends EnvironmentDataStatement<EvoSuiteRemoteAddress> {
    private static final long serialVersionUID = -4863601663573415059L;

    public RemoteAddressPrimitiveStatement(TestCase tc) {
        this(tc, (EvoSuiteRemoteAddress)null);
        this.randomize();
    }

    public RemoteAddressPrimitiveStatement(TestCase tc, EvoSuiteRemoteAddress value) {
        super(tc, (Type)((Object)EvoSuiteRemoteAddress.class), value);
    }

    @Override
    public String getTestCode(String varName) {
        String testCode = "";
        VariableReference retval = this.getReturnValue();
        Object value = this.getValue();
        if (value != null) {
            String escapedAddress = StringUtil.getEscapedString(((EvoSuiteAddress)value).getHost());
            int port = ((EvoSuiteAddress)value).getPort();
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = new " + ((Class)retval.getType()).getSimpleName() + "(\"" + escapedAddress + "\", " + port + ");\n";
        } else {
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = null;\n";
        }
        return testCode;
    }

    @Override
    public void delta() {
        this.randomize();
    }

    @Override
    public void zero() {
    }

    @Override
    public void randomize() {
        EvoSuiteRemoteAddress addr;
        boolean accessed;
        double threshold = 0.8;
        boolean bl = accessed = Randomness.nextDouble() <= threshold;
        if (accessed && !this.tc.getAccessedEnvironment().getViewOfRemoteContactedPorts().isEmpty()) {
            EndPointInfo info = Randomness.choice(this.tc.getAccessedEnvironment().getViewOfRemoteContactedPorts());
            String host = info.getHost();
            int port = info.getPort();
            port = this.getPort(port);
            addr = new EvoSuiteRemoteAddress(host, port);
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            String host = constantPool.getRandomString();
            int port = constantPool.getRandomInt();
            port = this.getPort(port);
            addr = new EvoSuiteRemoteAddress(host, port);
        }
        this.setValue(addr);
    }

    private int getPort(int port) {
        if (port <= 0 || port > 65535) {
            port = 12345;
        }
        return port;
    }
}

