/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.reflection;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.runtime.PrivateAccess;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericMethod;

public class PrivateFieldStatement
extends MethodStatement {
    private static final long serialVersionUID = 5152490398872348493L;
    private static Method setVariable;
    private GenericClass ownerClass;
    private String className;
    private String fieldName;
    private boolean isStaticField = false;

    public PrivateFieldStatement(TestCase tc, Class<?> klass, String fieldName, VariableReference callee, VariableReference param) throws NoSuchFieldException, IllegalArgumentException, ConstructionFailedException {
        super(tc, new GenericMethod(setVariable, PrivateAccess.class), null, Arrays.asList(new ConstantValue(tc, new GenericClass(Class.class), klass), callee, new ConstantValue(tc, new GenericClass(String.class), fieldName), param));
        this.ownerClass = new GenericClass(klass);
        this.className = this.ownerClass.getRawClass().getCanonicalName();
        this.fieldName = fieldName;
        ArrayList<GenericClass> parameterTypes = new ArrayList<GenericClass>();
        parameterTypes.add(this.ownerClass);
        this.method.setTypeParameters(parameterTypes);
        this.determineIfFieldIsStatic(klass, fieldName);
    }

    private void determineIfFieldIsStatic(Class<?> klass, String fieldName) {
        try {
            Field f = klass.getDeclaredField(fieldName);
            if (Modifier.isStatic(f.getModifiers())) {
                this.isStaticField = true;
            }
        }
        catch (NoSuchFieldException f) {
            throw new RuntimeException("EvoSuite bug", f);
        }
    }

    public boolean isStaticField() {
        return this.isStaticField;
    }

    public String getOwnerClassName() {
        return this.className;
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        try {
            VariableReference owner = ((VariableReference)this.parameters.get(1)).copy(newTestCase, offset);
            VariableReference value = ((VariableReference)this.parameters.get(3)).copy(newTestCase, offset);
            PrivateFieldStatement pf = new PrivateFieldStatement(newTestCase, this.ownerClass.getRawClass(), this.fieldName, owner, value);
            return pf;
        }
        catch (NoSuchFieldException | ConstructionFailedException e) {
            throw new RuntimeException("EvoSuite bug", e);
        }
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        return false;
    }

    @Override
    public boolean isReflectionStatement() {
        return true;
    }

    @Override
    public Throwable execute(Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        if (!this.isStaticField) {
            try {
                Object receiver = ((VariableReference)this.parameters.get(1)).getObject(scope);
                if (receiver == null) {
                    return new CodeUnderTestException(new NullPointerException());
                }
            }
            catch (CodeUnderTestException e) {
                return e;
            }
        }
        return super.execute(scope, out);
    }

    static {
        try {
            setVariable = PrivateAccess.class.getMethod("setVariable", Class.class, Object.class, String.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("EvoSuite bug", e);
        }
    }
}

