/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.AbstractTestChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearch;

public final class TestSuiteChromosome
extends AbstractTestSuiteChromosome<TestSuiteChromosome, TestChromosome> {
    private static final List<SecondaryObjective<TestSuiteChromosome>> secondaryObjectives = new ArrayList<SecondaryObjective<TestSuiteChromosome>>();
    private static int secondaryObjIndex = 0;
    private static final long serialVersionUID = 88380759969800800L;

    public static void addSecondaryObjective(SecondaryObjective<TestSuiteChromosome> objective) {
        secondaryObjectives.add(objective);
    }

    public static void ShuffleSecondaryObjective() {
        Collections.shuffle(secondaryObjectives);
    }

    public static int getSecondaryObjectivesSize() {
        return secondaryObjectives.size();
    }

    public static boolean isFirstSecondaryObjectiveEnabled() {
        return secondaryObjIndex == 0;
    }

    public static void disableFirstSecondaryObjective() {
        if (secondaryObjIndex != 1) {
            secondaryObjIndex = 1;
        }
    }

    public static void enableFirstSecondaryObjective() {
        if (secondaryObjIndex != 0) {
            secondaryObjIndex = 0;
        }
    }

    public static void reverseSecondaryObjective() {
        Collections.reverse(secondaryObjectives);
    }

    public static void removeSecondaryObjective(SecondaryObjective<TestSuiteChromosome> objective) {
        secondaryObjectives.remove(objective);
    }

    public static void removeAllSecondaryObjectives() {
        secondaryObjectives.clear();
    }

    @Override
    public TestSuiteChromosome self() {
        return this;
    }

    public TestSuiteChromosome() {
    }

    public TestSuiteChromosome(ChromosomeFactory<TestChromosome> testChromosomeFactory) {
        super(testChromosomeFactory);
    }

    protected TestSuiteChromosome(TestSuiteChromosome source) {
        super(source);
    }

    @Override
    public TestChromosome addTest(TestCase test) {
        TestChromosome c = new TestChromosome();
        c.setTestCase(test);
        this.addTest(c);
        return c;
    }

    @Override
    public void addTestChromosome(TestChromosome testChromosome) {
        this.addTest(testChromosome);
    }

    public void clearMutationHistory() {
        this.tests.forEach(t -> t.getMutationHistory().clear());
    }

    @Override
    public TestSuiteChromosome clone() {
        return new TestSuiteChromosome(this);
    }

    @Override
    public int compareSecondaryObjective(TestSuiteChromosome o) {
        SecondaryObjective<TestSuiteChromosome> so;
        int objective = secondaryObjIndex;
        int c = 0;
        while (c == 0 && objective < secondaryObjectives.size() && (so = secondaryObjectives.get(objective++)) != null) {
            c = so.compareChromosomes(this.self(), o);
        }
        return c;
    }

    @Override
    public void deleteTest(TestCase testCase) {
        if (testCase != null) {
            this.tests.removeIf(t -> t.getTestCase().equals(testCase));
        }
    }

    public Set<TestFitnessFunction> getCoveredGoals() {
        LinkedHashSet<TestFitnessFunction> goals = new LinkedHashSet<TestFitnessFunction>();
        for (TestChromosome t : this.tests) {
            Set<TestFitnessFunction> coveredGoals = t.getTestCase().getCoveredGoals();
            goals.addAll(coveredGoals);
        }
        return goals;
    }

    public void removeCoveredGoal(TestFitnessFunction f) {
        this.tests.forEach(t -> t.getTestCase().removeCoveredGoal(f));
    }

    public List<TestCase> getTests() {
        return this.tests.stream().map(AbstractTestChromosome::getTestCase).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean localSearch(LocalSearchObjective<TestSuiteChromosome> objective) {
        TestSuiteLocalSearch localSearch = TestSuiteLocalSearch.selectTestSuiteLocalSearch();
        return localSearch.doSearch(this, objective);
    }

    @Override
    public void mutate() {
        for (int i = 0; i < Properties.NUMBER_OF_MUTATIONS; ++i) {
            super.mutate();
        }
    }

    public String toString() {
        String result = "TestSuite: " + this.tests.size() + "\n";
        int i = 0;
        for (TestChromosome test : this.tests) {
            result = result + "Test " + i + ": \n";
            ++i;
            if (test.getLastExecutionResult() != null) {
                result = result + test.getTestCase().toCode(test.getLastExecutionResult().exposeExceptionMapping());
                continue;
            }
            result = result + test.getTestCase().toCode() + "\n";
        }
        return result;
    }
}

