/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import org.evosuite.Properties;
import org.evosuite.ga.ReplacementFunction;
import org.evosuite.testsuite.TestSuiteChromosome;

public class TestSuiteReplacementFunction
extends ReplacementFunction<TestSuiteChromosome> {
    private static final long serialVersionUID = -8472469271120247395L;

    public TestSuiteReplacementFunction(boolean maximize) {
        super(maximize);
    }

    public TestSuiteReplacementFunction() {
        super(false);
    }

    public int getLengthSum(TestSuiteChromosome chromosome1, TestSuiteChromosome chromosome2) {
        return chromosome1.totalLengthOfTestCases() + chromosome2.totalLengthOfTestCases();
    }

    @Override
    public boolean keepOffspring(TestSuiteChromosome parent1, TestSuiteChromosome parent2, TestSuiteChromosome offspring1, TestSuiteChromosome offspring2) {
        int cmp = this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2);
        if (Properties.CHECK_PARENTS_LENGTH) {
            int offspringLength = this.getLengthSum(offspring1, offspring2);
            int parentLength = this.getLengthSum(parent1, parent2);
            if (cmp == 0 && offspringLength <= parentLength) {
                return true;
            }
            if (this.maximize) {
                return cmp > 0;
            }
            return cmp < 0;
        }
        if (this.maximize) {
            return cmp >= 0;
        }
        return cmp <= 0;
    }
}

