/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;

public abstract class ArrayUtil {
    public static final String DEFAULT_JOIN_SEPARATOR = ", ";

    public static <T> Set<T> asSet(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    public static Integer[] box(int[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Long[] box(long[] array) {
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] box(byte[] array) {
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static String join(Object[] array, String separator) {
        return StringUtils.join(array, separator);
    }

    public static String join(Object[] array) {
        return StringUtils.join(array, DEFAULT_JOIN_SEPARATOR);
    }

    public static String join(long[] array, String separator) {
        return ArrayUtil.join((Object[])ArrayUtil.box(array), separator);
    }

    public static String join(long[] array) {
        return ArrayUtil.join(array, DEFAULT_JOIN_SEPARATOR);
    }

    public static String join(byte[] array, String separator) {
        return ArrayUtil.join((Object[])ArrayUtil.box(array), separator);
    }

    public static String join(byte[] array) {
        return ArrayUtil.join(array, DEFAULT_JOIN_SEPARATOR);
    }

    public static boolean contains(Object[] array, Object object) {
        for (Object obj : array) {
            if (obj == object) {
                return true;
            }
            if (obj != null && obj.equals(object)) {
                return true;
            }
            if (!(object instanceof String) || !obj.toString().equals(object)) continue;
            return true;
        }
        return false;
    }

    public static Object[] append(Object[] arr, Object obj) {
        int N = arr.length;
        arr = Arrays.copyOf(arr, N + 1);
        arr[N] = obj;
        return arr;
    }
}

