/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import org.evosuite.ClientProcess;
import org.evosuite.ConsoleProgressBar;
import org.evosuite.Properties;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.MasterServices;
import org.evosuite.rmi.service.ClientNodeRemote;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ExternalProcessGroupHandler {
    protected static final Logger logger = LoggerFactory.getLogger(ExternalProcessGroupHandler.class);
    protected Process[] processGroup;
    protected String[][] last_commands;
    protected Thread[] output_printers;
    protected Thread[] error_printers;
    protected Thread[] message_handlers;
    protected ObjectInputStream in;
    protected Object final_result;
    protected static final Object WAITING_FOR_DATA = "waiting_for_data_" + System.currentTimeMillis();
    protected Thread[] processKillHooks;
    protected Thread clientRunningOnThread;
    protected volatile CountDownLatch[] latches;
    protected String base_dir = System.getProperty("user.dir");
    private String[] hsErrFiles;

    public ExternalProcessGroupHandler() {
        this(1);
    }

    public ExternalProcessGroupHandler(int nrOfProcesses) {
        this.processGroup = new Process[nrOfProcesses];
        this.last_commands = new String[nrOfProcesses][];
        this.output_printers = new Thread[nrOfProcesses];
        this.error_printers = new Thread[nrOfProcesses];
        this.message_handlers = new Thread[nrOfProcesses];
        this.processKillHooks = new Thread[nrOfProcesses];
        this.latches = new CountDownLatch[nrOfProcesses];
        this.hsErrFiles = new String[nrOfProcesses];
    }

    public void stopAndWaitForClientOnThread(long ms) {
        if (this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            this.clientRunningOnThread.interrupt();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < ms && this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            try {
                this.clientRunningOnThread.join(ms - (System.currentTimeMillis() - start));
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            throw new AssertionError((Object)("clientRunningOnThread is alive even after waiting " + ms + "ms"));
        }
    }

    public void setBaseDir(String base_dir) {
        this.base_dir = base_dir;
    }

    public boolean startProcess(String[] commands) {
        ArrayList<String[]> l_commands = new ArrayList<String[]>();
        l_commands.add(commands);
        return this.startProcessGroup(l_commands);
    }

    public boolean startProcessGroup(List<String[]> commands) {
        int i;
        int rollbackToI = 0;
        for (i = 0; i < commands.size(); ++i) {
            Object[] command = commands.get(i);
            if (!Properties.IS_RUNNING_A_SYSTEM_TEST) {
                logger.debug("Going to start process with command: " + Arrays.toString(command).replace(",", " "));
            }
            LinkedList<String> formatted = new LinkedList<String>();
            for (Object s : command) {
                String token = ((String)s).trim();
                if (token.isEmpty()) continue;
                formatted.add(token);
            }
            this.hsErrFiles[i] = "hs_err_EvoSuite_client_p" + this.getServerPort() + "_t" + System.currentTimeMillis();
            String option = "-XX:ErrorFile=" + this.hsErrFiles[i];
            formatted.add(1, option);
            if (this.startProcess(formatted.toArray(new String[0]), i, null)) continue;
            rollbackToI = i;
            break;
        }
        if (rollbackToI > 0) {
            for (i = 0; i < rollbackToI; ++i) {
                this.killProcess(i);
            }
        }
        return rollbackToI == 0;
    }

    protected boolean didClientJVMCrash(int processIndex) {
        return new File(this.hsErrFiles[processIndex]).exists();
    }

    protected String getAndDeleteHsErrFile(int processIndex) {
        if (!this.didClientJVMCrash(processIndex)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        File file = new File(this.hsErrFiles[processIndex]);
        file.deleteOnExit();
        try (Scanner in = new Scanner(file);){
            String row;
            while (in.hasNextLine() && (row = in.nextLine()).startsWith("#")) {
                builder.append(row).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Error while reading " + file.getAbsolutePath() + ": " + e.getMessage());
            return null;
        }
        return builder.toString();
    }

    public String getProcessStates() {
        if (this.processGroup == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.processGroup.length; ++i) {
            builder.append("process nr. ");
            builder.append(i);
            builder.append(": ");
            if (this.processGroup[i] == null) {
                builder.append("null\n");
                continue;
            }
            try {
                int exitValue = this.processGroup[i].exitValue();
                builder.append("Terminated with exit status ");
                builder.append(exitValue);
                builder.append("\n");
                continue;
            }
            catch (IllegalThreadStateException e) {
                builder.append("Still running\n");
            }
        }
        return builder.toString();
    }

    protected boolean startProcess(String[] command, final int processIndex, Object population_data) {
        if (this.processGroup[processIndex] != null) {
            logger.warn("Already running an external process");
            return false;
        }
        this.latches[processIndex] = new CountDownLatch(1);
        this.final_result = WAITING_FOR_DATA;
        this.processKillHooks[processIndex] = new Thread(){

            @Override
            public void run() {
                ExternalProcessGroupHandler.this.killProcess(processIndex);
                ExternalProcessGroupHandler.this.closeServer();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.processKillHooks[processIndex]);
        if (!Properties.CLIENT_ON_THREAD) {
            File dir = new File(this.base_dir);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(dir);
            builder.redirectErrorStream(false);
            try {
                this.processGroup[processIndex] = builder.start();
            }
            catch (IOException e) {
                logger.error("Failed to start external process", e);
                return false;
            }
            this.startExternalProcessPrinter(processIndex);
        } else {
            this.clientRunningOnThread = new Thread(){

                @Override
                public void run() {
                    ClientProcess.main(new String[0]);
                }
            };
            this.clientRunningOnThread.setName("client");
            this.clientRunningOnThread.start();
            Sandbox.addPrivilegedThread(this.clientRunningOnThread);
        }
        this.startSignalHandler(processIndex);
        this.last_commands[processIndex] = command;
        return true;
    }

    public void killProcess() {
        this.killProcess(0);
    }

    public void killProcess(int processIndex) {
        if (this.processGroup[processIndex] == null) {
            return;
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.processKillHooks[processIndex]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.processGroup[processIndex] != null) {
            try {
                this.processGroup[processIndex].getOutputStream().close();
                this.processGroup[processIndex].getInputStream().close();
                this.processGroup[processIndex].getErrorStream().close();
            }
            catch (Exception t) {
                logger.error("Failed to close process stream: " + t.toString());
            }
            this.processGroup[processIndex].destroy();
        }
        this.processGroup[processIndex] = null;
        if (this.clientRunningOnThread != null && this.clientRunningOnThread.isAlive()) {
            this.clientRunningOnThread.interrupt();
        }
        this.clientRunningOnThread = null;
        if (this.output_printers[processIndex] != null && this.output_printers[processIndex].isAlive()) {
            this.output_printers[processIndex].interrupt();
        }
        this.output_printers[processIndex] = null;
        if (this.error_printers[processIndex] != null && this.error_printers[processIndex].isAlive()) {
            this.error_printers[processIndex].interrupt();
        }
        this.error_printers[processIndex] = null;
        if (this.message_handlers[processIndex] != null && this.message_handlers[processIndex].isAlive()) {
            this.message_handlers[processIndex].interrupt();
        }
        this.message_handlers[processIndex] = null;
    }

    public void killAllProcesses() {
        for (int i = 0; i < this.processGroup.length; ++i) {
            this.killProcess(i);
        }
    }

    public int getServerPort() {
        return MasterServices.getInstance().getRegistryPort();
    }

    public int openServer() {
        boolean started = MasterServices.getInstance().startRegistry();
        if (!started) {
            logger.error("Not possible to start RMI registry");
            return -1;
        }
        try {
            MasterServices.getInstance().registerServices();
        }
        catch (RemoteException e) {
            logger.error("Failed to start RMI services", e);
            return -1;
        }
        return MasterServices.getInstance().getRegistryPort();
    }

    public void closeServer() {
        MasterServices.getInstance().stopServices();
    }

    protected void startExternalProcessPrinter(final int processIndex) {
        if (this.output_printers[processIndex] == null || !this.output_printers[processIndex].isAlive()) {
            this.output_printers[processIndex] = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader proc_in = new BufferedReader(new InputStreamReader(ExternalProcessGroupHandler.this.processGroup[processIndex].getInputStream()));
                        int data = 0;
                        while (data != -1 && !this.isInterrupted()) {
                            data = proc_in.read();
                            if (data == -1 || !Properties.PRINT_TO_SYSTEM) continue;
                            System.out.print((char)data);
                        }
                    }
                    catch (Exception e) {
                        if (MasterServices.getInstance().getMasterNode() == null) {
                            return;
                        }
                        boolean finished = true;
                        for (ClientState state : MasterServices.getInstance().getMasterNode().getCurrentState()) {
                            if (state == ClientState.DONE) continue;
                            finished = false;
                            break;
                        }
                        if (!finished) {
                            logger.error("Exception while reading output of client process. " + e.getMessage());
                        }
                        logger.debug("Exception while reading output of client process. " + e.getMessage());
                    }
                }
            };
            this.output_printers[processIndex].start();
        }
        if (this.error_printers[processIndex] == null || !this.error_printers[processIndex].isAlive()) {
            this.error_printers[processIndex] = new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader proc_in = new BufferedReader(new InputStreamReader(ExternalProcessGroupHandler.this.processGroup[processIndex].getErrorStream()));
                        int data = 0;
                        String errorLine = "";
                        while (data != -1 && !this.isInterrupted()) {
                            data = proc_in.read();
                            if (data == -1 || !Properties.PRINT_TO_SYSTEM) continue;
                            System.err.print((char)data);
                            errorLine = errorLine + (char)data;
                            if ((char)data != '\n') continue;
                            logger.error(errorLine);
                            errorLine = "";
                        }
                    }
                    catch (Exception e) {
                        if (MasterServices.getInstance().getMasterNode() == null) {
                            return;
                        }
                        boolean finished = true;
                        for (ClientState state : MasterServices.getInstance().getMasterNode().getCurrentState()) {
                            if (state == ClientState.DONE) continue;
                            finished = false;
                            break;
                        }
                        if (!finished) {
                            logger.error("Exception while reading output of client process. " + e.getMessage());
                        }
                        logger.debug("Exception while reading output of client process. " + e.getMessage());
                    }
                }
            };
            this.error_printers[processIndex].start();
        }
        if (Properties.SHOW_PROGRESS && (Properties.LOG_LEVEL == null || !Properties.LOG_LEVEL.equals("info") && !Properties.LOG_LEVEL.equals("debug") && !Properties.LOG_LEVEL.equals("trace"))) {
            ConsoleProgressBar.startProgressBar();
        }
    }

    protected void startExternalProcessMessageHandler(final int processIndex) {
        if (this.message_handlers[processIndex] != null && this.message_handlers[processIndex].isAlive()) {
            return;
        }
        this.message_handlers[processIndex] = new Thread(){

            @Override
            public void run() {
                boolean read = true;
                while (read && !this.isInterrupted()) {
                    String message = null;
                    Object data = null;
                    try {
                        message = (String)ExternalProcessGroupHandler.this.in.readObject();
                        data = ExternalProcessGroupHandler.this.in.readObject();
                        logger.debug("Received msg: " + message);
                        logger.debug("Received data: " + data);
                    }
                    catch (Exception e) {
                        logger.error("Class " + Properties.TARGET_CLASS + ". Error when reading message. Likely the client has crashed. Error message: " + e.getMessage());
                        message = "FINISHED_COMPUTATION";
                        data = null;
                    }
                    if (message.equals("FINISHED_COMPUTATION")) {
                        LoggingUtils.getEvoLogger().info("* Computation finished");
                        read = false;
                        ExternalProcessGroupHandler.this.killProcess(processIndex);
                        ExternalProcessGroupHandler.this.final_result = data;
                        ExternalProcessGroupHandler.this.latches[processIndex].countDown();
                        continue;
                    }
                    if (message.equals("NEED_RESTART")) {
                        LoggingUtils.getEvoLogger().info("* Restarting client process");
                        ExternalProcessGroupHandler.this.killProcess(processIndex);
                        ExternalProcessGroupHandler.this.startProcess(ExternalProcessGroupHandler.this.last_commands[processIndex], processIndex, data);
                        continue;
                    }
                    ExternalProcessGroupHandler.this.killProcess(processIndex);
                    logger.error("Class " + Properties.TARGET_CLASS + ". Error, received invalid message: ", (Object)message);
                    return;
                }
            }
        };
        this.message_handlers[processIndex].start();
    }

    protected void startSignalHandler(final int processIndex) {
        Signal.handle(new Signal("INT"), new SignalHandler(){
            private boolean interrupted = false;

            @Override
            public void handle(Signal arg0) {
                if (this.interrupted) {
                    System.exit(0);
                }
                try {
                    this.interrupted = true;
                    if (ExternalProcessGroupHandler.this.processGroup[processIndex] != null) {
                        ExternalProcessGroupHandler.this.processGroup[processIndex].waitFor();
                    }
                }
                catch (InterruptedException e) {
                    logger.warn("", e);
                }
            }
        });
    }

    public TestGenerationResult waitForResult(int timeout) {
        block12: {
            try {
                long start = System.currentTimeMillis();
                Map<String, ClientNodeRemote> clients = MasterServices.getInstance().getMasterNode().getClientsOnceAllConnected(timeout);
                if (clients == null) {
                    logger.error("Could not access client process");
                    return TestGenerationResultBuilder.buildErrorResult("Could not access client process");
                }
                for (Map.Entry<String, ClientNodeRemote> entry : clients.entrySet()) {
                    long passed = System.currentTimeMillis() - start;
                    long remaining = (long)timeout - passed;
                    if (remaining <= 0L) {
                        remaining = 1L;
                    }
                    boolean finished = false;
                    ClientState clientState = MasterServices.getInstance().getMasterNode().getCurrentState(entry.getKey());
                    if (clientState == null || !clientState.equals((Object)ClientState.FINISHED)) {
                        try {
                            finished = entry.getValue().waitUntilFinished(remaining);
                        }
                        catch (ConnectException e) {
                            logger.warn("Failed to connect to client. Client with id " + entry.getKey() + " is already finished.");
                            finished = true;
                        }
                    } else {
                        finished = true;
                    }
                    if (finished) continue;
                    logger.error("Class " + Properties.TARGET_CLASS + ". Clients have not finished yet, although a timeout occurred.\n" + MasterServices.getInstance().getMasterNode().getSummaryOfClientStatuses());
                }
            }
            catch (InterruptedException start) {
            }
            catch (RemoteException e) {
                String msg = "Class " + Properties.TARGET_CLASS + ". Lost connection with clients.\n" + MasterServices.getInstance().getMasterNode().getSummaryOfClientStatuses();
                boolean crashOccurred = false;
                for (int i = 0; i < this.processGroup.length; ++i) {
                    if (!this.didClientJVMCrash(i)) continue;
                    String err = this.getAndDeleteHsErrFile(i);
                    String clientMsg = "The JVM of the client process crashed:\n" + err;
                    logger.error(clientMsg);
                    crashOccurred = true;
                }
                if (!crashOccurred) break block12;
                logger.error(msg, e);
            }
        }
        for (int i = 0; i < this.processGroup.length; ++i) {
            this.killProcess(i);
        }
        LoggingUtils.getEvoLogger().info("* Computation finished");
        return null;
    }
}

