
    
def retrieve_parameters(model_name, df_logger, with_temperature=False, require_best=True, retrieve_index=None):
    # Retrieve the best model checkpoint and its score based on the model name from logger
    subset_df = df_logger[df_logger['Model']==model_name]
    if require_best:
        retrieve_index = subset_df['Score'].idxmax()
        best_model_ckpt = subset_df.loc[retrieve_index]['Path']
    else:
        best_model_ckpt = subset_df.loc[retrieve_index]['Path']

    if with_temperature:
        return best_model_ckpt, subset_df.loc[retrieve_index]['Score'], subset_df.loc[retrieve_index]['Temperature']
    else:
        return best_model_ckpt, subset_df.loc[retrieve_index]['Score']
        




