#!/bin/bash
JOB_ID=10#$1
DATA_ROOT=$DATA_ROOT
TRACE_ROOT=$DATA_ROOT/traces
CKPT_ROOT=$RESULTS_ROOT
OUT_ROOT=$RESULTS_ROOT/eval

if [ ! -d $OUT_ROOT ]
then
    mkdir $OUT_ROOT
fi

ALL_BNET_CKPT=( # 15 models
    # tune 5
    $CKPT_ROOT/barrier_net_tune_5/version_0/checkpoints/epoch\=9-step\=9568.ckpt # weird step num
    $CKPT_ROOT/barrier_net_tune_5/version_5/checkpoints/epoch\=4-step\=14619.ckpt
    $CKPT_ROOT/barrier_net_tune_5/version_5/checkpoints/epoch\=9-step\=29239.ckpt
    $CKPT_ROOT/barrier_net_tune_5/version_6/checkpoints/epoch\=4-step\=14619.ckpt
    $CKPT_ROOT/barrier_net_tune_5/version_6/checkpoints/epoch\=9-step\=29239.ckpt
    $CKPT_ROOT/barrier_net_tune_5/version_8/checkpoints/epoch\=4-step\=14619.ckpt
    $CKPT_ROOT/barrier_net_tune_5/version_8/checkpoints/epoch\=9-step\=29239.ckpt
    $CKPT_ROOT/barrier_net_tune_5/version_9/checkpoints/epoch\=3-step\=10233.ckpt # probably stop
    # tune 6
    $CKPT_ROOT/barrier_net_tune_6/version_0/checkpoints/epoch\=4-step\=14619.ckpt
    $CKPT_ROOT/barrier_net_tune_6/version_0/checkpoints/epoch\=9-step\=29239.ckpt
    $CKPT_ROOT/barrier_net_tune_6/version_1/checkpoints/epoch\=4-step\=14619.ckpt
    $CKPT_ROOT/barrier_net_tune_6/version_1/checkpoints/epoch\=9-step\=29239.ckpt
    $CKPT_ROOT/barrier_net_tune_6/version_2/checkpoints/epoch\=4-step\=14619.ckpt
    $CKPT_ROOT/barrier_net_tune_6/version_2/checkpoints/epoch\=9-step\=29239.ckpt
    $CKPT_ROOT/barrier_net_tune_6/version_3/checkpoints/epoch\=4-step\=14619.ckpt
    $CKPT_ROOT/barrier_net_tune_6/version_3/checkpoints/epoch\=9-step\=29239.ckpt
)

ALL_SNET_CKPT=( # 30 models
    # state net 7
    $CKPT_ROOT/state_net_7/version_0/checkpoints/epoch\=9-step\=20823.ckpt
    $CKPT_ROOT/state_net_7/version_1/checkpoints/epoch\=9-step\=21919.ckpt
    $CKPT_ROOT/state_net_7/version_1/checkpoints/epoch\=19-step\=43839.ckpt
    $CKPT_ROOT/state_net_7/version_1/checkpoints/epoch\=29-step\=65759.ckpt
    $CKPT_ROOT/state_net_7/version_2/checkpoints/epoch\=9-step\=21919.ckpt
    $CKPT_ROOT/state_net_7/version_2/checkpoints/epoch\=19-step\=43839.ckpt
    $CKPT_ROOT/state_net_7/version_2/checkpoints/epoch\=29-step\=65759.ckpt
    $CKPT_ROOT/state_net_7/version_3/checkpoints/epoch\=9-step\=21919.ckpt
    $CKPT_ROOT/state_net_7/version_3/checkpoints/epoch\=19-step\=43839.ckpt
    $CKPT_ROOT/state_net_7/version_3/checkpoints/epoch\=29-step\=65759.ckpt
    # state net 8
    $CKPT_ROOT/state_net_8/version_6/checkpoints/epoch\=9-step\=21919.ckpt
    $CKPT_ROOT/state_net_8/version_6/checkpoints/epoch\=19-step\=43839.ckpt
    $CKPT_ROOT/state_net_8/version_6/checkpoints/epoch\=29-step\=65759.ckpt
    $CKPT_ROOT/state_net_8/version_7/checkpoints/epoch\=9-step\=21919.ckpt
    $CKPT_ROOT/state_net_8/version_7/checkpoints/epoch\=19-step\=43839.ckpt
    $CKPT_ROOT/state_net_8/version_7/checkpoints/epoch\=29-step\=65759.ckpt
    $CKPT_ROOT/state_net_8/version_8/checkpoints/epoch\=9-step\=21919.ckpt
    $CKPT_ROOT/state_net_8/version_8/checkpoints/epoch\=19-step\=43839.ckpt
    $CKPT_ROOT/state_net_8/version_8/checkpoints/epoch\=29-step\=65759.ckpt
    $CKPT_ROOT/state_net_8/version_9/checkpoints/epoch\=9-step\=21919.ckpt
    $CKPT_ROOT/state_net_8/version_9/checkpoints/epoch\=19-step\=43839.ckpt
    $CKPT_ROOT/state_net_8/version_9/checkpoints/epoch\=29-step\=65759.ckpt
    # state net 9
    $CKPT_ROOT/state_net_9/version_1/checkpoints/epoch\=9-step\=45468.ckpt
    $CKPT_ROOT/state_net_9/version_1/checkpoints/epoch\=19-step\=90938.ckpt
    $CKPT_ROOT/state_net_9/version_2/checkpoints/epoch\=9-step\=45468.ckpt
    $CKPT_ROOT/state_net_9/version_2/checkpoints/epoch\=19-step\=90938.ckpt
    $CKPT_ROOT/state_net_9/version_3/checkpoints/epoch\=9-step\=38628.ckpt
    $CKPT_ROOT/state_net_9/version_3/checkpoints/epoch\=19-step\=77258.ckpt
    $CKPT_ROOT/state_net_9/version_4/checkpoints/epoch\=9-step\=38628.ckpt
    $CKPT_ROOT/state_net_9/version_3/checkpoints/epoch\=19-step\=77258.ckpt
)

N_BNET_CKPT=${#ALL_BNET_CKPT[@]}
N_SNET_CKPT=${#ALL_SNET_CKPT[@]}

BNET_CKPT_IDX=$((JOB_ID/N_SNET_CKPT))
BNET_CKPT="${ALL_BNET_CKPT[BNET_CKPT_IDX]}"

SNET_CKPT_IDX=$((JOB_ID%N_SNET_CKPT))
SNET_CKPT="${ALL_SNET_CKPT[SNET_CKPT_IDX]}"

OUT_DIR=$OUT_ROOT/bnet_${BNET_CKPT_IDX}_snet_${SNET_CKPT_IDX}

args=(
    # env
    --trace-paths $TRACE_ROOT/20210527-131252_lexus_devens_center_outerloop
                  $TRACE_ROOT/20210527-131709_lexus_devens_center_outerloop_reverse
                  $TRACE_ROOT/20210609-122400_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20210609-123703_lexus_devens_outerloop
                  $TRACE_ROOT/20210609-133320_lexus_devens_outerloop
                  $TRACE_ROOT/20210609-154745_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20210609-155238_lexus_devens_outerloop
                  $TRACE_ROOT/20210609-175037_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20210609-175503_lexus_devens_outerloop
                  $TRACE_ROOT/20210613-171636_lexus_devens_outerloop
                  $TRACE_ROOT/20210613-172102_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20210613-193528_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20210726-131322_lexus_devens_center
                  $TRACE_ROOT/20210726-131912_lexus_devens_center_reverse
                  $TRACE_ROOT/20210726-154641_lexus_devens_center
                  $TRACE_ROOT/20210726-155941_lexus_devens_center_reverse
                  $TRACE_ROOT/20210726-184624_lexus_devens_center
                  $TRACE_ROOT/20210726-184956_lexus_devens_center_reverse
                  $TRACE_ROOT/20211114-145502_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20220113-130450_lexus_devens_outerloop_outdoor_wb
                  $TRACE_ROOT/20220113-130914_lexus_devens_outerloop_reverse_outdoor_wb
                  $TRACE_ROOT/20220113-131457_lexus_devens_outerloop
                  $TRACE_ROOT/20220113-131922_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20220113-134438_lexus_devens_outerloop_reverse
                  $TRACE_ROOT/20220113-135302_lexus_devens_outerloop
    --mesh-dir $DATA_ROOT/carpack01/
    --n-agents 2
    --reset-mode uniform # default
    --use-curvilinear-dynamics
    --n-episodes 30
    --max-step 100
    --init-dist-range 15 25
    --init-lat-noise-range 1 1.5
    # logging
    --out-dir $OUT_DIR
    # --use-display
    # --save-video
    # barrier net
    --model-module barrier_net
    --ckpt $BNET_CKPT
    # --set-obs-d-lower-bound 1
    # --use-reference-control
    # state net
    --state-net-model-module state_net
    --state-net-ckpt $SNET_CKPT
)

echo "bnet $BNET_CKPT_IDX snet $SNET_CKPT_IDX"
echo "${args[@]}"
if [ ! -d $OUT_DIR ]; then
    python eval.py "${args[@]}"
else
    echo "skip " $OUT_DIR
fi