#!/bin/bash

# TRACE_ROOT=$HOME/data/vista/traces
# TRACE_DST=$HOME/mnt/robosim/data/vista/traces
TRACE_ROOT=/robosim/data/vista/traces
TRACE_DST=/local/traces

if [ ! -d $TRACE_DST ]
then
    mkdir $TRACE_DST
fi

ALL_TRACES=(
    $TRACE_ROOT/20210527-131252_lexus_devens_center_outerloop
    $TRACE_ROOT/20210527-131709_lexus_devens_center_outerloop_reverse
    $TRACE_ROOT/20210609-122400_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20210609-123703_lexus_devens_outerloop
    $TRACE_ROOT/20210609-133320_lexus_devens_outerloop
    $TRACE_ROOT/20210609-154745_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20210609-155238_lexus_devens_outerloop
    $TRACE_ROOT/20210609-175037_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20210609-175503_lexus_devens_outerloop
    $TRACE_ROOT/20210613-171636_lexus_devens_outerloop
    $TRACE_ROOT/20210613-172102_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20210613-193528_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20210726-131322_lexus_devens_center
    $TRACE_ROOT/20210726-131912_lexus_devens_center_reverse
    $TRACE_ROOT/20210726-154641_lexus_devens_center
    $TRACE_ROOT/20210726-155941_lexus_devens_center_reverse
    $TRACE_ROOT/20210726-184624_lexus_devens_center
    $TRACE_ROOT/20210726-184956_lexus_devens_center_reverse
    $TRACE_ROOT/20211114-145502_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20220113-130450_lexus_devens_outerloop_outdoor_wb
    $TRACE_ROOT/20220113-130914_lexus_devens_outerloop_reverse_outdoor_wb
    $TRACE_ROOT/20220113-131457_lexus_devens_outerloop
    $TRACE_ROOT/20220113-131922_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20220113-134438_lexus_devens_outerloop_reverse
    $TRACE_ROOT/20220113-135302_lexus_devens_outerloop
)

for TRACE in "${ALL_TRACES[@]}"
do
    rsync -arh --info=progress2 $TRACE $TRACE_DST # --dry-run
done
