# main.py
import os
import argparse
from code.train import train_main
from code.core import MDE_CV
from code.utils import regression_metrics
import warnings
warnings.filterwarnings('ignore', category=UserWarning) 
warnings.filterwarnings(
    "ignore", 
    message="invalid value encountered in divide", 
    category=RuntimeWarning
)
def main(args):
    # Ensure directories
    os.makedirs(os.path.dirname(args.output_model), exist_ok=True)
    os.makedirs(os.path.dirname(args.results_pickle), exist_ok=True)

    # Train
    mde = train_main(args.input_csv, args.target, args.output_model)

    # Predict
    print("Running model.predict()")
    preds = mde.predict()
    pred_incremental = mde.predict_incremental(plot=0)
    # Save train and test results 
    mde.save_results(args.results_pickle)
    print(f"Results saved to {args.results_pickle}")


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Full MDE_CV pipeline")
    parser.add_argument("--input_csv", required=True, help="CSV path")
    parser.add_argument("--target", required=True, help="Target column")
    parser.add_argument("--output_model", default="models/mde_model.pkl", help="Model pickle path")
    parser.add_argument("--results_pickle", default="models/results.pkl", help="Results pickle path")
    args = parser.parse_args()
    main(args)
