
import cplex
import time
from itertools import *
import numpy as np
import csv
import pandas as pd
import random
from sys import argv
import math
import random
from scipy.stats import gmean
#from docplex.mp.model import Model
from gurobipy import Model, GRB
from gurobipy import quicksum

def core_check(X,S,A,kp,ka,u,numrev, numpap):
	L1=10000


	problem = Model()
	problem.Params.IntegralityFocus = 1
	problem.Params.Threads=15
	problem.Params.TimeLimit=2000
	problem.setParam('OutputFlag', False)
	R = problem.addVars(numrev, vtype=GRB.BINARY,name='reviewers')
	P = problem.addVars(numpap, vtype=GRB.BINARY, name='submissions')
	F = problem.addVars(numrev,numpap, vtype=GRB.BINARY, name='assignment')
	d = problem.addVar(vtype=GRB.CONTINUOUS, lb=0.0,   name='value')
	problem.addConstrs((F[i,j] <= R[i] for i in range(numrev) for j in range(numpap))) #assign p to r if r deviates
	problem.addConstrs((F[i,j] <= P[j] for i in range(numrev) for j in range(numpap))) #assign p to r if p deviates
	problem.addConstrs((F[i,j] <= 1- A[i,j] for i in range(numrev) for j in range(numpap)))#r cannot review p if r is the author of p
	problem.addConstrs((P[j]*A[i,j] <= R[i] for i in range(numrev) for j in range(numpap)))
	problem.addConstrs( (quicksum( [F[i,j] for j in range(numrev) ]) <= ka* R[i]  for i in range(numrev)) ) #if r deviates,  it can be assigned at most ka submissions
	problem.addConstrs(( R[i]<= quicksum( [P[j]*A[i,j] for j in range(numrev) ]) for i in range(numrev)  ))
	problem.addConstrs(( quicksum( [F[i,j] for i in range(numrev) ])== kp* P[j]  for j in range(numpap)) ) #if p deviates,  it should be assigned to kp reviewers
	problem.addConstrs( (  quicksum([ F[i,j]*A[i1,j]*S[i,j] for i in range(numrev) for j in range(numpap) ]) >=  (u[i1]+0.000001)*d-(1-R[i1])*L1 for i1 in range(numrev)))
	#problem.addConstrs( (  quicksum([ F[i,j]*A[i1,j]*S[i,j] for i in range(numrev) for j in range(numpap) ]) >=  0.00001-(1-R[i1])*L1 for i1 in range(numrev)))

	problem.addConstr(  quicksum( [R[i] for i in range(numrev) ] ) *10000 >= d  ) #At least one agent deviates
	problem.update()
	problem.setObjective(d, GRB.MAXIMIZE)
	problem.update()
	problem.optimize()

	infin=1
	if d.x<1:
		infin=0
	else:
		for i in range(numrev):
			if (R[i].x>=0.5):
				if (u[i]>0):
					infin=0
					break
	coun=0
	for i in range(numrev):
		if (R[i].x>0.0001):
			if (u[i]>sum(F[i1,j].x*S[i1,j]*A[i,j] for j in range(numpap) for i1 in range(numrev))):

				if (d.x>1):
					print("Problem",R[i].x)
					exit()
			coun+=1
			print(u[i],"b",sum(F[i1,j].x*S[i1,j]*A[i,j] for j in range(numpap) for i1 in range(numrev)),R[i].x)
	if (d.x>1 and coun<1):
		print("Problem",d.x)
		exit()

	print("Coalition Size",coun )

	print("alpha",d.x,problem.status)

	return max(d.x,1),infin,coun

def core_check_size(X,S,A,kp,ka,u,numrev, numpap):
	L1=10000


	problem = Model()
	problem.Params.IntegralityFocus = 1
	problem.Params.Threads=15
	problem.Params.TimeLimit=2000
	problem.setParam('OutputFlag', False)
	R = problem.addVars(numrev, vtype=GRB.BINARY,name='reviewers')
	P = problem.addVars(numpap, vtype=GRB.BINARY, name='submissions')
	F = problem.addVars(numrev,numpap, vtype=GRB.BINARY, name='assignment')
	d = problem.addVar(vtype=GRB.CONTINUOUS, lb=0.0,   name='value')
	problem.addConstrs((F[i,j] <= R[i] for i in range(numrev) for j in range(numpap))) #assign p to r if r deviates
	problem.addConstrs((F[i,j] <= P[j] for i in range(numrev) for j in range(numpap))) #assign p to r if p deviates
	problem.addConstrs((F[i,j] <= 1- A[i,j] for i in range(numrev) for j in range(numpap)))#r cannot review p if r is the author of p
	problem.addConstrs((P[j]*A[i,j] <= R[i] for i in range(numrev) for j in range(numpap)))
	problem.addConstrs( (quicksum( [F[i,j] for j in range(numrev) ]) <= ka* R[i]  for i in range(numrev)) ) #if r deviates,  it can be assigned at most ka submissions
	problem.addConstrs(( R[i]<= quicksum( [P[j]*A[i,j] for j in range(numrev) ]) for i in range(numrev)  ))
	problem.addConstrs(( quicksum( [F[i,j] for i in range(numrev) ])== kp* P[j]  for j in range(numpap)) ) #if p deviates,  it should be assigned to kp reviewers
	problem.addConstrs( (  quicksum([ F[i,j]*A[i1,j]*S[i,j] for i in range(numrev) for j in range(numpap) ]) >=  (u[i1]+0.0001)*d-(1-R[i1])*L1 for i1 in range(numrev)))
	#problem.addConstrs( (  quicksum([ F[i,j]*A[i1,j]*S[i,j] for i in range(numrev) for j in range(numpap) ]) >=  0.00001-(1-R[i1])*L1 for i1 in range(numrev)))

	problem.addConstr(  quicksum( [R[i] for i in range(numrev) ] ) *10000 >= d  ) #At least one agent deviates
	problem.addConstr( d>= 1.0001) #Find a deviating coalition
	problem.update()
	problem.setObjective(quicksum( [R[i] for j in range(numrev) ]), GRB.MAXIMIZE)
	problem.update()
	problem.optimize()
	print("Problem status",problem.status)
	if problem.status==3:
		 alpha=1
		 infin=0
		 coun=0
	else:
		infin=1
		if d.x<1:
			infin=0
		else:
			for i in range(numrev):
				if (R[i].x>=0.5):
					if (u[i]>0):
						infin=0
						break
		coun=0
		for i in range(numrev):
			if (R[i].x>0.0001):
				if (u[i]>sum(F[i1,j].x*S[i1,j]*A[i,j] for j in range(numpap) for i1 in range(numrev))):

					if (d.x>1):
						print("Problem",R[i].x)
						exit()
				coun+=1
				print(u[i],"b",sum(F[i1,j].x*S[i1,j]*A[i,j] for j in range(numpap) for i1 in range(numrev)),R[i].x)
		if (d.x>1 and coun<1):
			print("Problem",d.x,"here")
			exit()
		coun=0
		if d.x>1:
			for i in range(numrev):
				if (R[i].x>0.05):
					coun+=1

		print("alpha",d.x,problem.status)
		print("Coalition Size",coun )
		alpha=max(d.x,1)

	return alpha,infin,coun
