#!/bin/bash

echo "SparseNuclearNorm Creating data"
python3 sparse_nuclear_norm_create_data.py

for BETA in 0.001 0.0001; do

for METHOD in TOS TOS-LS; do
    echo "Submitting job SparseNuclearNorm Beta="${BETA}" "${METHOD}
    python3 sparse_nuclear_norm_run_method.py --beta ${BETA} --method ${METHOD}
    sleep 1; 
done

for GAMMA in 0.01 0.1 1. 10. 100.; do
    echo "Submitting job SparseNuclearNorm Beta="${BETA}" AdaptTOS gamma0="${GAMMA}
    python3 sparse_nuclear_norm_run_method.py --beta ${BETA} --gamma0 ${GAMMA} --method AdapTOS
    sleep 1;
done

for TAU in 0.1 0.5 0.9; do
for METHOD in PDHG PDHG-LS; do
    echo "Submitting job SparseNuclearNorm Beta="${BETA}" "${METHOD}" tau="${TAU}
    python3 sparse_nuclear_norm_run_method.py --beta ${BETA} --tau ${TAU} --method ${METHOD}
    sleep 1;
done
done

done
