%%
close all

ORIG = double(rgb2gray(imread('images/building_org.png')))./255;


OCC = double(imread('images/building_occluded_spnoise.jpg'))./255;

L1 = load('runs/TOS_L1.pkl.mat');
L2 = load('runs/TOS_L2.pkl.mat');
L2Sq = load('runs/TOS_L2SQ.pkl.mat');

hfig = figure('Position',[100,100,1000,1000]);
set(hfig,'name','impainting-images-occluded','numbertitle','off');

subplot(131)
imshow(ORIG)
title('Original image','Interpreter','latex','FontSize',13)
subplot(132)
imshow(OCC)
title('Occluded noisy image','Interpreter','latex','FontSize',13)
xlabel(['PSNR = ',num2str(psnr(OCC,ORIG,1))],'Interpreter','latex','FontSize',13)

subplot(133)
imshow(L2.z_final)
title('Recovered Image (squared-$\ell_2$)','Interpreter','latex','FontSize',13)
xlabel({['PSNR = ',num2str(psnr(L2Sq.z_av_final,ORIG,1))],['(1000 iterations, ',num2str(round(L2.time(end),2)),' sec)']},'Interpreter','latex','FontSize',13)


hfig = figure('Position',[100,100,1000,1000]);
set(hfig,'name','impainting-images-recovered','numbertitle','off');


subplot(131)
imshow(L1.z_av_final)
title('Recovered Image ($\ell_1$)','Interpreter','latex','FontSize',13)
xlabel({['PSNR = ',num2str(psnr(L1.z_av_final,ORIG,1))],['(1000 iterations, ',num2str(round(L1.time(end),2)),' sec)']},'Interpreter','latex','FontSize',13)
subplot(132)
imshow(L2.z_final)
title('Recovered Image ($\ell_2$)','Interpreter','latex','FontSize',13)
xlabel({['PSNR = ',num2str(psnr(L2.z_av_final,ORIG,1))],['(1000 iterations, ',num2str(round(L2.time(end),2)),' sec)']},'Interpreter','latex','FontSize',13)
subplot(133)
imshow(L2.z_final)
title('Recovered Image (squared-$\ell_2$)','Interpreter','latex','FontSize',13)
xlabel({['PSNR = ',num2str(psnr(L2Sq.z_av_final,ORIG,1))],['(1000 iterations, ',num2str(round(L2Sq.time(end),2)),' sec)']},'Interpreter','latex','FontSize',13)
