#!/bin/bash

echo "TV_Deblurring Creating data"
python3 tv_deblurring_create_data.py

for BETA in 0.0001 0.000001; do

for METHOD in TOS TOS-LS; do
    echo "Submitting job TV Deblurring Beta="${BETA}" "${METHOD}
    python3 tv_deblurring_run_method.py --beta ${BETA} --method ${METHOD}
    sleep 0.1; 
done

for GAMMA in 0.01 0.1 1. 10. 100.; do
    echo "Submitting job TV Deblurring Beta="${BETA}" AdaptTOS gamma0="${GAMMA}
    python3 tv_deblurring_run_method.py --beta ${BETA} --gamma0 ${GAMMA} --method AdapTOS
    sleep 0.1;
done

for TAU in 0.1 0.5 0.9; do
for METHOD in PDHG PDHG-LS; do
    echo "Submitting job TV Deblurring Beta="${BETA}" "${METHOD}" tau="${TAU}
    python3 tv_deblurring_run_method.py --beta ${BETA} --tau ${TAU} --method ${METHOD}
    sleep 0.1;
done
done

done