% close all
% clear all

c_adaptos = [0,0,0];
c_tos = [0.6,0.08,0.2];
c_pdhg = [0.9,0.7,0.12];

hfig = figure('Position',[100,100,1100,560]);
set(hfig,'name','numerics-smooth','numbertitle','off');

%% Overlapping Group Lasso (synthetic) 0.001

subplot(2,4,1)

AdapTOS = load('runs/overlapping_group_lasso/Reg0.001_AdapTOS_gamma0=10.0.mat');
TOS = load('runs/overlapping_group_lasso/Reg0.001_TOS.mat');
TOS_LS = load('runs/overlapping_group_lasso/Reg0.001_TOS-LS.mat');
PDHG = load('runs/overlapping_group_lasso/Reg0.001_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/overlapping_group_lasso/Reg0.001_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-11,1e3])

title('OG Lasso - Synth. ($\lambda = 10^{-3}$)','Interpreter','latex','FontSize',13)
   
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
xlim([0,20]);
subplot(2,4,4)
xlim([0,300]);

%% Overlapping Group Lasso (synthetic) 0.1

subplot(2,4,2)

AdapTOS = load('runs/overlapping_group_lasso/Reg0.1_AdapTOS_gamma0=1.0.mat');
TOS = load('runs/overlapping_group_lasso/Reg0.1_TOS.mat');
TOS_LS = load('runs/overlapping_group_lasso/Reg0.1_TOS-LS.mat');
PDHG = load('runs/overlapping_group_lasso/Reg0.1_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/overlapping_group_lasso/Reg0.1_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-11,1e3])
xlim([0,5]);

ax = gca;

title('OG Lasso - Synth. ($\lambda = 10^{-1}$)','Interpreter','latex','FontSize',13)

%% Overlapping Group Lasso (real-sim) 0.001

subplot(2,4,3)

AdapTOS = load('runs/Realsim//Reg0.001_AdapTOS_gamma0=100.0.mat');
TOS = load('runs/Realsim/Reg0.001_TOS.mat');
TOS_LS = load('runs/Realsim/Reg0.001_TOS-LS.mat');
PDHG = load('runs/Realsim/Reg0.001_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/Realsim/Reg0.001_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-11,1e3])

title('OG Lasso - real-sim ($\lambda = 10^{-3}$)','Interpreter','latex','FontSize',13)
   
% ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
xlim([0,300]);
subplot(2,4,4)
xlim([0,300]);


%% Overlapping Group Lasso (real-sim) 0.01

subplot(2,4,4)

AdapTOS = load('runs/Realsim//Reg0.01_AdapTOS_gamma0=100.0.mat');
TOS = load('runs/Realsim/Reg0.01_TOS.mat');
TOS_LS = load('runs/Realsim/Reg0.01_TOS-LS.mat');
PDHG = load('runs/Realsim/Reg0.01_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/Realsim/Reg0.01_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-11,1e3])

title('OG Lasso - real-sim ($\lambda = 10^{-2}$)','Interpreter','latex','FontSize',13)
   
% ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
xlim([0,300]);
subplot(2,4,4)
xlim([0,300]);
%% Sparse Nuclear Norm 0.0001

subplot(2,4,5)

AdapTOS = load('runs/sparse_nuclear_norm/Reg0.0001_AdapTOS_gamma0=1.0.mat');
TOS = load('runs/sparse_nuclear_norm/Reg0.0001_TOS.mat');
TOS_LS = load('runs/sparse_nuclear_norm/Reg0.0001_TOS-LS.mat');
PDHG = load('runs/sparse_nuclear_norm/Reg0.0001_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/sparse_nuclear_norm/Reg0.0001_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-11,1e-1])

ax = gca;

title('Sparse \& low-rank ($\lambda = 10^{-4}$)','Interpreter','latex','FontSize',13)
   
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);

xlim([0,60]);


%% Sparse Nuclear Norm 0.001

subplot(2,4,6)

AdapTOS = load('runs/sparse_nuclear_norm/Reg0.001_AdapTOS_gamma0=1.0.mat');
TOS = load('runs/sparse_nuclear_norm/Reg0.001_TOS.mat');
TOS_LS = load('runs/sparse_nuclear_norm/Reg0.001_TOS-LS.mat');
PDHG = load('runs/sparse_nuclear_norm/Reg0.001_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/sparse_nuclear_norm/Reg0.001_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-11,1e-1])

ax = gca;

title('Sparse \& low-rank ($\lambda = 10^{-3}$)','Interpreter','latex','FontSize',13)
   
% ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
xlim([0,10]);
% subplot(2,4,4)
% xlim([0,300]);

%% TV Deblurring 1e-06

subplot(2,4,7)

AdapTOS = load('runs/tv_deblurring/Reg1e-06_AdapTOS_gamma0=100.0.mat');
TOS = load('runs/tv_deblurring/Reg1e-06_TOS.mat');
TOS_LS = load('runs/tv_deblurring/Reg1e-06_TOS-LS.mat');
PDHG = load('runs/tv_deblurring/Reg1e-06_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/tv_deblurring/Reg1e-06_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-12,1e0])

ax = gca;

title('Total variation ($\lambda = 10^{-6}$)','Interpreter','latex','FontSize',13)
   
% ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
xlim([0,100]);
subplot(2,4,8)
xlim([0,100]);

%% TV Deblurring 0.0001

subplot(2,4,8)

AdapTOS = load('runs/tv_deblurring/Reg0.0001_AdapTOS_gamma0=100.0.mat');
TOS = load('runs/tv_deblurring/Reg0.0001_TOS.mat');
TOS_LS = load('runs/tv_deblurring/Reg0.0001_TOS-LS.mat');
PDHG = load('runs/tv_deblurring/Reg0.0001_PDHG_tau=0.5.mat');
PDHG_LS = load('runs/tv_deblurring/Reg0.0001_PDHG-LS_tau=0.5.mat');

fmin = min([TOS.trace(end), TOS_LS.trace(end), PDHG.trace(end), PDHG_LS.trace(end), AdapTOS.trace(end)]);
semilogy(TOS.trace_time, TOS.trace - fmin, 'color', c_tos); hold on
semilogy(TOS_LS.trace_time, TOS_LS.trace - fmin, '--', 'color', c_tos);
semilogy(PDHG.trace_time, PDHG.trace - fmin, 'color', c_pdhg);
semilogy(PDHG_LS.trace_time, PDHG_LS.trace - fmin, '--', 'color', c_pdhg);
semilogy(AdapTOS.trace_time, AdapTOS.trace - fmin,'color',c_adaptos);

ylim([1e-12,1e0])

ax = gca;

title('Total variation ($\lambda = 10^{-4}$)','Interpreter','latex','FontSize',13)
   
% ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
xlim([0,100]);
subplot(2,4,8)
xlim([0,100]);

%%
for t = 1:8
    subplot(2,4,t)
    if t>=5
    xlabel('time (sec)','Interpreter','latex','FontSize',13);
    end
    
    ax = gca;
    set(findall(ax, 'Type', 'line'),'LineWidth',2);
    ax.FontSize = 13;
    ax.TickLabelInterpreter = 'latex';
    ax.TickDir = 'out';
    set(gca,'TickDir','out')
    set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
    ax.Box = 'on';
    
    ax.YTick = 10.^(-100:2:100);
    XLIMITS = xlim;
    ax.XTick = (linspace(XLIMITS(1), XLIMITS(2) ,5));
    
    ax.YRuler.MinorTick = 'on'; %or 'off'
    ax.YRuler.MinorTickValues = 10.^(-99:2:99); %just like major ticks
%     ax.YRuler.MinorTickValuesMode = 'auto'; %or 'manual'
    
    grid on, grid minor
end


