% close all
clear all

hfig = figure('Position',[100,100,1100,270]);
set(hfig,'name','adaptos_HingeLoss','numbertitle','off');

%% Overlapping Group Lasso RCV1

listall = dir('runs/HingeLoss/Reg0.001*.mat');
fmin = [];
for t = 1:length(listall)
    data = load(['runs/HingeLoss/',listall(t).name]);
    fmin(end+1) = data.trace(end);
end
fmin = min(fmin);

list = dir('runs/HingeLoss/Reg0.001_AdapTOS_gamma*.mat');
AdapTOS = {};
for t = 1:length(list)
    AdapTOS{end+1} = load(['runs/HingeLoss/',list(t).name]);
end

mylegend = {};
for t = 1:length(AdapTOS)
    subplot(1,4,1)
    loglog(AdapTOS{t}.trace - fmin); hold on
    
    subplot(1,4,2)
    loglog(AdapTOS{t}.trace_time, AdapTOS{t}.trace - fmin); hold on
    
    mylegend{end+1} = ['$\gamma_0 = ', num2str(AdapTOS{t}.gamma_0), '$'];
end

subplot(1,4,1)
title('$\lambda = 10^{-3}$', 'Interpreter','latex','FontSize',13)
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
xlabel('iteration','Interpreter','latex','FontSize',13);
ylim([1e-9,1e3])

subplot(1,4,2)
title('$\lambda = 10^{-3}$', 'Interpreter','latex','FontSize',13)
xlabel('time (sec)','Interpreter','latex','FontSize',13);
ylim([1e-9,1e3])

%%
listall = dir('runs/HingeLoss/Reg0.01*.mat');
fmin = [];
for t = 1:length(listall)
    data = load(['runs/HingeLoss/',listall(t).name]);
    fmin(end+1) = data.trace(end);
end
fmin = min(fmin);


list = dir('runs/HingeLoss/Reg0.01_AdapTOS_gamma*.mat');

AdapTOS = {};
for t = 1:length(list)
    AdapTOS{end+1} = load(['runs/HingeLoss/',list(t).name]);
end

mylegend = {};
for t = 1:length(AdapTOS)
    subplot(1,4,3)
    loglog(AdapTOS{t}.trace - fmin); hold on
    
    subplot(1,4,4)
    loglog(AdapTOS{t}.trace_time, AdapTOS{t}.trace - fmin); hold on
    
    mylegend{end+1} = ['$\gamma_0 = ', num2str(AdapTOS{t}.gamma_0), '$'];
end

subplot(1,4,3)
title('$\lambda = 10^{-2}$', 'Interpreter','latex','FontSize',13)
xlabel('iteration','Interpreter','latex','FontSize',13);
ylim([1e-9,1e3])

subplot(1,4,4)
title('$\lambda = 10^{-2}$', 'Interpreter','latex','FontSize',13)
xlabel('time (sec)','Interpreter','latex','FontSize',13);
ylim([1e-9,1e3])

subplot(1,4,1)
hleg = legend(mylegend);
hleg.Interpreter = 'latex';
hleg.FontSize = 12;
hleg.Location = 'SouthWest';

for t = 1:4
    subplot(1,4,t)
    
    ax = gca;
    set(findall(ax, 'Type', 'line'),'LineWidth',2);
    ax.FontSize = 13;
    ax.TickLabelInterpreter = 'latex';
    ax.TickDir = 'out';
    set(gca,'TickDir','out')
    set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
    ax.Box = 'on';
    
    ax.YTick = 10.^(-100:3:100);
    ax.XTick = 10.^(-100:1:100);
    
    grid on, grid minor, grid minor
end



