close all
clear all

hfig = figure('Position',[100,100,1100,250]);
set(hfig,'name','numerics-nonsmooth','numbertitle','off');

c_adaptos = [0,0,0];

%% Overlapping Group Lasso Real-Sim

L1 = load('runs/TOS_L1.pkl.mat');
L2 = load('runs/TOS_L2.pkl.mat');

subplot(1,4,1)
OPTL1 = 8669.381964654458; % found with cvx
hplot = loglog(abs(L1.z_obj - OPTL1)/OPTL1, 'color', c_adaptos); hold on
loglog(abs(L1.z_av_obj - OPTL1)/OPTL1,':', 'color', hplot.Color)
% hplot = loglog(L1.time, abs(L1.z_obj - OPTL1)/OPTL1); hold on
% loglog(L1.time, abs(L1.z_av_obj - OPTL1)/OPTL1,':', 'color', hplot.Color)
title('$\ell_1$ -loss','Interpreter','latex','FontSize',12)
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
ax = gca;
ax.YTick = 10.^(-100:1:100);    
ylim([1e-2,10])
ax.YRuler.MinorTick = 'off'; %or 'off'

hl = legend('Last it.','Ergodic it.');
hl.Interpreter = 'latex';
hl.FontSize = 13;
hl.Location = 'southwest';

subplot(1,4,2)
loglog(L1.xz_gap, 'color', hplot.Color); hold on
loglog(L1.xz_avg_gap, ':','color', hplot.Color)
% loglog(L1.time, L1.xz_gap, 'color', hplot.Color); hold on
% loglog(L1.time, L1.xz_avg_gap, ':','color', hplot.Color)
title('$\ell_1$ -loss','Interpreter','latex','FontSize',12)
ylabel('infeasibility','Interpreter','latex','FontSize',13);
ax = gca;
ax.YTick = 10.^(-100:1:100);    
ylim([1e-2,10^3])
ax.YRuler.MinorTick = 'off'; %or 'off'


subplot(1,4,3)
OPTL2 = 49.534038003823056;
loglog(abs(L2.z_obj - OPTL2)/OPTL2, 'color', hplot.Color); hold on
loglog(abs(L2.z_av_obj - OPTL2)/OPTL2,':', 'color', hplot.Color)
% loglog(L2.time, abs(L2.z_obj - OPTL2)/OPTL2); hold on
% loglog(L2.time, abs(L2.z_av_obj - OPTL2)/OPTL2,':', 'color', hplot.Color)
title('$\ell_2$ -loss','Interpreter','latex','FontSize',12)
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
ylim([1e-12,1e0])
ax = gca;
ax.YTick = 10.^(-100:2:100);
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 10.^(-99:2:99); %just like major ticks




subplot(1,4,4)
loglog(L2.xz_gap, 'color', hplot.Color); hold on
loglog(L2.xz_avg_gap, ':','color', hplot.Color)
% loglog(L2.time, L2.xz_gap, 'color', hplot.Color); hold on
% loglog(L2.time, L2.xz_avg_gap, ':','color', hplot.Color)
title('$\ell_2$ -loss','Interpreter','latex','FontSize',12)
ylabel('infeasibility','Interpreter','latex','FontSize',13);
ylim([1e-11,1e2])
ax = gca;
ax.YTick = 10.^(-100:2:100);
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 10.^(-99:2:99); %just like major ticks

for t = 1:4
    subplot(1,4,t)
%     xlabel('time (sec)','Interpreter','latex','FontSize',13);
    xlabel('iteration','Interpreter','latex','FontSize',13);
    
    ax = gca;
    set(findall(ax, 'Type', 'line'),'LineWidth',2);
    ax.FontSize = 13;
    ax.TickLabelInterpreter = 'latex';
    ax.TickDir = 'out';
    set(gca,'TickDir','out')
    set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
    ax.Box = 'on';
    
    ax.XTick = 10.^(-100:1:100);    
    grid on, grid minor, grid minor;
    
    ax.XRuler.MinorTick = 'off'; %or 'off'
end



