import os

def get_command(num_epochs, lr, optimizer, reg_factor):
    return f"python3 cifar-10.py --num_epochs {num_epochs} --lr {lr} --optimizer {optimizer} --reg_factor {reg_factor}"

reg_factor = 0.00001
num_epochs = 5
for lr in [0.001, 0.01, 0.1, 1, 10]:
    for optimizer in ["sgd", "adagrad", "momentum", "adaptos"]:
        command = get_command(num_epochs, lr, optimizer, reg_factor)
        file_name = f"output/out_cifar_{optimizer}_{lr}.txt"
        bash_command = f"{command} > {file_name} &"
        print(bash_command)
        print("wait")