#!/bin/bash

for BETA in 0.001 0.01; do

for METHOD in TOS TOS-LS; do
    echo "Submitting job Real-Sim Beta="${BETA}" "${METHOD}
    python3 Realsim_run_method.py --beta ${BETA} --method ${METHOD}
    sleep 0.1; 
done

for GAMMA in 0.01 0.1 1. 10. 100. 1000.; do
    echo "Submitting job Real-Sim Beta="${BETA}" AdapTOS gamma0="${GAMMA}
    python3 Realsim_run_method.py --beta ${BETA} --gamma0 ${GAMMA} --method AdapTOS
    sleep 0.1;
done

for TAU in 0.1 0.5 0.9; do
for METHOD in PDHG PDHG-LS; do
    echo "Submitting job Real-Sim Beta="${BETA}" "${METHOD}" tau="${TAU}
    python3 Realsim_run_method.py --beta ${BETA} --tau ${TAU} --method ${METHOD}
    sleep 0.1;
done
done

done