"""
Total variation regularization
==============================

Comparison of solvers with total variation regularization.
"""

import numpy as np
from PIL import Image
from scipy import misc
from scipy import sparse
import pickle
import os

np.random.seed(1)

img = misc.face(gray=True).astype(np.float)
# resize
img = np.array(Image.fromarray(img).resize((153, 115)))
img = img.astype(np.float) / img.max()

n_rows, n_cols = img.shape
n_features = n_rows * n_cols
n_samples = n_features

# .. compute blurred and noisy image ..
A = sparse.load_npz("data/blur_matrix.npz")
b = A.dot(img.ravel())

# ... save data ...

if not os.path.exists('data'):
    os.makedirs('data')

with open("data/tv_deblurring.pkl", 'wb') as fh:
    pickle.dump({'A': A, 'b': b, 'n_features': n_features, 'n_samples': n_samples, 'n_rows': n_rows, 'n_cols': n_cols}, fh)
