close all
clear all

hfig = figure('Position',[100,100,1100,550]);
set(hfig,'name','numerics-nonsmooth-supp','numbertitle','off');

c_adaptos = [0,0,0];

%% Overlapping Group Lasso Real-Sim

L1 = load('runs/TOS_L1.pkl.mat');
L2 = load('runs/TOS_L2.pkl.mat');
L2SQ = load('runs/TOS_L2SQ.pkl.mat');

%% L1
subplot(2,4,1)
OPTL1 = 8669.381964654458; % found with cvx
hplot = loglog(abs(L1.z_obj - OPTL1)/OPTL1, 'color', c_adaptos); hold on
loglog(abs(L1.z_av_obj - OPTL1)/OPTL1,'--', 'color', hplot.Color)
% hplot = loglog(L1.time, abs(L1.z_obj - OPTL1)/OPTL1); hold on
% loglog(L1.time, abs(L1.z_av_obj - OPTL1)/OPTL1,'--', 'color', hplot.Color)
title('$\ell_1$ loss','Interpreter','latex','FontSize',12)
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
ax = gca;
ax.YTick = 10.^(-100:1:100);    
ylim([1e-2,10])
ax.YRuler.MinorTick = 'off'; %or 'off'

hl = legend('Last iteration','Ergodic average');
hl.Interpreter = 'latex';
hl.FontSize = 13;
hl.Location = 'southwest';

subplot(2,4,2)
loglog(L1.xz_gap, 'color', hplot.Color); hold on
loglog(L1.xz_avg_gap, '--','color', hplot.Color)
% loglog(L1.time, L1.xz_gap, 'color', hplot.Color); hold on
% loglog(L1.time, L1.xz_avg_gap, '--','color', hplot.Color)
title('$\ell_1$ loss','Interpreter','latex','FontSize',12)
ylabel('infeasibility','Interpreter','latex','FontSize',13);
ax = gca;
ax.YTick = 10.^(-100:1:100);    
ylim([1e-2,10^3])
ax.YRuler.MinorTick = 'off'; %or 'off'

%% L2
subplot(2,4,3)
OPTL2 = 49.534038003823057;
loglog(abs(L2.z_obj - OPTL2)/OPTL2, 'color', hplot.Color); hold on
loglog(abs(L2.z_av_obj - OPTL2)/OPTL2,'--', 'color', hplot.Color)
% loglog(L2.time, abs(L2.z_obj - OPTL2)/OPTL2); hold on
% loglog(L2.time, abs(L2.z_av_obj - OPTL2)/OPTL2,'--', 'color', hplot.Color)
title('$\ell_2$ loss','Interpreter','latex','FontSize',12)
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
ylim([1e-11,1e1])
ax = gca;
ax.YTick = 10.^(-99:2:99);
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 10.^(-100:2:100); %just like major ticks

subplot(2,4,4)
loglog(L2.xz_gap, 'color', hplot.Color); hold on
loglog(L2.xz_avg_gap, '--','color', hplot.Color)
% loglog(L2.time, L2.xz_gap, 'color', hplot.Color); hold on
% loglog(L2.time, L2.xz_avg_gap, '--','color', hplot.Color)
title('$\ell_2$ loss','Interpreter','latex','FontSize',12)
ylabel('infeasibility','Interpreter','latex','FontSize',13);
ylim([1e-11,1e3])
ax = gca;
ax.YTick = 10.^(-99:2:99);
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 10.^(-100:2:100); %just like major ticks


%% L2SQ
subplot(2,4,5)
OPTL2SQ = 1226.8104604820951;
loglog(abs(L2SQ.z_obj - OPTL2SQ)/OPTL2SQ, 'color', hplot.Color); hold on
loglog(abs(L2SQ.z_av_obj - OPTL2SQ)/OPTL2SQ,'--', 'color', hplot.Color)
% loglog(L2SQ.time, abs(L2SQ.z_obj - OPTL2SQ)/OPTL2SQ); hold on
% loglog(L2SQ.time, abs(L2SQ.z_av_obj - OPTL2SQ)/OPTL2SQ,'--', 'color', hplot.Color)
title('squared-$\ell_2$ loss','Interpreter','latex','FontSize',12)
ylabel('objective suboptimality','Interpreter','latex','FontSize',13);
ylim([1e-11,1e1])
ax = gca;
ax.YTick = 10.^(-99:2:99);
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 10.^(-100:2:100); %just like major ticks

subplot(2,4,6)
loglog(L2SQ.xz_gap, 'color', hplot.Color); hold on
loglog(L2SQ.xz_avg_gap, '--','color', hplot.Color)
% loglog(L2SQ.time, L2SQ.xz_gap, 'color', hplot.Color); hold on
% loglog(L2SQ.time, L2SQ.xz_avg_gap, '--','color', hplot.Color)
title('squared-$\ell_2$ loss','Interpreter','latex','FontSize',12)
ylabel('infeasibility','Interpreter','latex','FontSize',13);
ylim([1e-11,1e3])
ax = gca;
ax.YTick = 10.^(-99:2:99);
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 10.^(-100:2:100); %just like major ticks

%% PSNR Comparison

subplot(2,4,7)
semilogx(L1.z_psnr, 'color', [0.7, 0.4, 0.4]); hold on
semilogx(L2.z_psnr, 'color', [0.6, 0.75, 0.6]); hold on
semilogx(L2SQ.z_psnr, 'color', [0.4, 0.4, 0.7]); hold on
title('last iteration estimate','Interpreter','latex','FontSize',12)
ylabel('peak signal to noise ratio','Interpreter','latex','FontSize',13);
ylim([10, 27])
ax = gca;
ax.YTick = 2:3:1000;
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 0:1000; %just like major ticks


subplot(2,4,8)
semilogx(L1.z_av_psnr, 'color', [0.7, 0.4, 0.4]); hold on
semilogx(L2.z_av_psnr, 'color', [0.6, 0.75, 0.6]); hold on
semilogx(L2SQ.z_av_psnr, 'color', [0.4, 0.4, 0.7]); hold on
title('ergodic average estimate','Interpreter','latex','FontSize',12)
ylabel('peak signal to noise ratio','Interpreter','latex','FontSize',13);
ylim([10, 27])
ax = gca;
ax.YTick = 2:3:1000;
ax.YRuler.MinorTick = 'on'; %or 'off'
ax.YRuler.MinorTickValues = 0:1000; %just like major ticks

hl2 = legend('$\ell_1$ loss','$\ell_2$ loss', 'squared-$\ell_2$ loss');
hl2.Interpreter = 'latex';
hl2.FontSize = 13;
hl2.Location = 'southeast';


%% Make the plots pretty!
for t = 1:8
    subplot(2,4,t)
%     xlabel('time (sec)','Interpreter','latex','FontSize',13);
    xlabel('iteration','Interpreter','latex','FontSize',13);
    
    ax = gca;
    set(findall(ax, 'Type', 'line'),'LineWidth',2);
    ax.FontSize = 13;
    ax.TickLabelInterpreter = 'latex';
    ax.TickDir = 'out';
    set(gca,'TickDir','out')
    set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
    ax.Box = 'on';
    
    ax.XTick = 10.^(-100:1:100);    
    grid on, grid minor, grid minor;
    
    ax.XRuler.MinorTick = 'off'; %or 'off'
end



