%% Plot results
c_adaptos = [1,0,0];
c_ntos = [0,0,1];
c_tos = [0,0,0];

close all

hfig = figure('Position',[100,100,1300,700]);
set(hfig,'name','numerics-isotonic-regression','numbertitle','off');

tt = 0;

for p = [1,1.3,1.7,2]
    

    dirname = ['./runs/isotonic_regression/p=',num2str(p),'/'];
    list = dir([dirname,'*.mat']);
    
    
    objerrNonsmoothTOS_ergodic = [];
    objerrAdapTOS_ergodic = [];
    objerrNonsmoothTOS_last = [];
    objerrAdapTOS_last = [];
    
    feasNonsmoothTOS_ergodic = [];
    feasAdapTOS_ergodic = [];
    feasNonsmoothTOS_last = [];
    feasAdapTOS_last = [];
    
    if p == 2
        objerrTOS_ergodic = [];
        objerrTOS_last = [];
        feasTOS_ergodic = [];
        feasTOS_last = [];
    end
    
    cvx_optval = [];
    for t = 1:length(list)
        data = load([dirname,list(t).name]);
        data = data.data;
        
        objerrAdapTOS_ergodic(:,end+1) = abs(data.outAdapTOS.err_av-data.cvx_optval)/data.cvx_optval;
        objerrNonsmoothTOS_ergodic(:,end+1) = abs(data.outNTOS.err_av-data.cvx_optval)/data.cvx_optval;
        objerrAdapTOS_last(:,end+1) = abs(data.outAdapTOS.err-data.cvx_optval)/data.cvx_optval;
        objerrNonsmoothTOS_last(:,end+1) = abs(data.outNTOS.err-data.cvx_optval)/data.cvx_optval;
        
        feasAdapTOS_ergodic(:,end+1) = data.outAdapTOS.feas_av;
        feasNonsmoothTOS_ergodic(:,end+1) = data.outNTOS.feas_av;
        feasAdapTOS_last(:,end+1) = data.outAdapTOS.feas;
        feasNonsmoothTOS_last(:,end+1) = data.outNTOS.feas;
        
        if p == 2
            
            objerrTOS_ergodic(:,end+1) = abs(data.outTOS.err_av-data.cvx_optval)/data.cvx_optval;
            objerrTOS_last(:,end+1) = abs(data.outTOS.err-data.cvx_optval)/data.cvx_optval;
            feasTOS_ergodic(:,end+1) = data.outTOS.feas_av;
            feasTOS_last(:,end+1) = data.outTOS.feas;
            
        end
        
    end
    
    objerrAdapTOS_ergodic_mean = mean(objerrAdapTOS_ergodic,2);
    objerrNonsmoothTOS_ergodic_mean = mean(objerrNonsmoothTOS_ergodic,2);
    objerrAdapTOS_last_mean = mean(objerrAdapTOS_last,2);
    objerrNonsmoothTOS_last_mean = mean(objerrNonsmoothTOS_last,2);
    
    feasAdapTOS_ergodic_mean = mean(feasAdapTOS_ergodic,2);
    feasNonsmoothTOS_ergodic_mean = mean(feasNonsmoothTOS_ergodic,2);
    feasAdapTOS_last_mean = mean(feasAdapTOS_last,2);
    feasNonsmoothTOS_last_mean = mean(feasNonsmoothTOS_last,2);
    
    if p == 2
        objerrTOS_ergodic_mean = mean(objerrTOS_ergodic,2);
        objerrTOS_last_mean = mean(objerrTOS_last,2);
        feasTOS_ergodic_mean = mean(feasTOS_ergodic,2);
        feasTOS_last_mean = mean(feasTOS_last,2);
    end
    
    %% Plot
    
    subplot(2,4,1+tt)
    hold off
    loglog(objerrAdapTOS_last_mean,'Color',c_adaptos);
    hold on;
    loglog(objerrNonsmoothTOS_last_mean,'Color',c_ntos);
    if p == 2, loglog(objerrTOS_last_mean,'Color',c_tos); end
    loglog(objerrAdapTOS_ergodic_mean,'--','Color',c_adaptos);
    loglog(objerrNonsmoothTOS_ergodic_mean,'--','Color',c_ntos);
    if p == 2, loglog(objerrTOS_ergodic_mean,'--','Color',c_tos); end
    
    title(['$p = ',num2str(p),'$'],'Interpreter','latex','FontSize',14)
    ylabel('relative objective suboptimality','Interpreter','latex','FontSize',14);
    xlabel('iteration','Interpreter','latex','FontSize',14);
        
    
    subplot(2,4,5+tt)
    hold off
    loglog(feasAdapTOS_last_mean,'Color',c_adaptos);
    hold on;
    loglog(feasNonsmoothTOS_last_mean,'Color',c_ntos);
    if p == 2, loglog(feasTOS_last_mean,'Color',c_tos); end
    loglog(feasAdapTOS_ergodic_mean,'--','Color',c_adaptos);
    loglog(feasNonsmoothTOS_ergodic_mean,'--','Color',c_ntos);
    if p == 2, loglog(feasTOS_ergodic_mean,'--','Color',c_tos); end
    
    title(['$p = ',num2str(p),'$'],'Interpreter','latex','FontSize',14)
    ylabel('infeasibility','Interpreter','latex','FontSize',14);
    xlabel('iteration','Interpreter','latex','FontSize',14);
    
    for t = 1:8
        subplot(2,4,t)
        
        ax = gca;
        set(findall(ax, 'Type', 'line'),'LineWidth',2);
        ax.FontSize = 14;
        ax.TickLabelInterpreter = 'latex';
        ax.TickDir = 'out';
        set(gca,'TickDir','out')
        set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
        ax.Box = 'on';
        
        ax.YTick = 10.^(-100:100);
        ax.XTick = 10.^(-100:100);
        
        ylim([1e-5-eps,1e1]);
        
        grid on, grid minor, grid minor
    end
    
    %% 
    tt = tt + 1;
    
end

%%
subplot(248)
hl = legend('AdapTOS','TOS: $\gamma_t = \gamma_0 / \sqrt{t+1}$','TOS: $\gamma_t = 1/L_f$');
hl.Interpreter = 'latex';
hl.FontSize = 14;
hl.Location = 'NorthEast';
