import os

def get_command(dataset, lr, optimizer):
    return f"python3 run_simulation_prox.py --dataset {dataset} --lr {lr} --optimizer {optimizer}"

def run_experiments_1():
    for dataset in ["mnist", "digits"]:
        for lr in [0.001, 0.01, 0.1, 1, 10, 100]:
            for optimizer in ["sgd", "adagrad", "adam", "adaptos", "tos"]:
                command = get_command(dataset, lr, optimizer)
                file_name = f"output/out_{dataset}_{optimizer}_{lr}.txt"
                bash_command = f"nohup {command} > {file_name} &"
                os.system(bash_command)
                print(f"executed {bash_command}")

def get_command_2(optimizer, seed):
    return f"python3 run_simulation_prox.py --dataset mnist --optimizer {optimizer} --seed {seed}"

def run_experiments_2():
    for optimizer in ["sgd", "adagrad", "adam", "adaptos", "tos"]:
        for seed in range(20):
            c = get_command_2(optimizer, seed)
            print(c)