close all

%% Plot results
c_det = [0.8,0.3,0];
c_sto = [0,0.3,0.8];


for p = [1,2]
    
    hfig = figure('Position',[100,100,1300,650]);
    set(hfig,'name',['numerics-portfolio-optimization-p=',num2str(p)],'numbertitle','off');
    
    for t = 1:4
        
        switch t
            case 1
                dataName = 'SP500';
            case 2
                dataName = 'TSE';
            case 3
                dataName = 'NYSE';
            case 4
                dataName = 'DJIA';
        end
        data = load(['./runs/portfolio_optimization/',dataName,'/p=',num2str(p),'.mat']);
        data = data.output;
        m = data.size(1);
                
        objerrDeterministic_ergodic = abs(data.AdapTOS.info.err_av-data.CVX.optval)/abs(data.CVX.optval);
        objerrDeterministic_last = abs(data.AdapTOS.info.err-data.CVX.optval)/abs(data.CVX.optval);
        feasDeterministic_ergodic = data.AdapTOS.info.feas_av;
        feasDeterministic_last = data.AdapTOS.info.feas;
        
        MC = length(data.StoAdapTOS.info);
        objerrStochastic_ergodic = [];
        objerrStochastic_last = [];
        feasStochastic_ergodic = [];
        feasStochastic_last = [];
        for mc = 1:MC
            objerrStochastic_ergodic(:,end+1) = abs(data.StoAdapTOS.info{mc}.err_av-data.CVX.optval)/abs(data.CVX.optval);
            objerrStochastic_last(:,end+1) = abs(data.StoAdapTOS.info{mc}.err-data.CVX.optval)/abs(data.CVX.optval);
            feasStochastic_ergodic(:,end+1) = data.StoAdapTOS.info{mc}.feas_av;
            feasStochastic_last(:,end+1) = data.StoAdapTOS.info{mc}.feas;
        end
        
        objerrStochastic_ergodic_mean = mean(objerrStochastic_ergodic,2);
        objerrStochastic_last_mean = mean(objerrStochastic_last,2);
        feasStochastic_ergodic_mean = mean(feasStochastic_ergodic,2);
        feasStochastic_last_mean = mean(feasStochastic_last,2);
                
        epochDet = (1:length(objerrDeterministic_ergodic))';
        epochSto = (1:length(objerrStochastic_ergodic_mean))'/m;
        
        
        %% Plot
        subplot(2,4,t)
        hold off
        semilogy(epochSto,objerrStochastic_last_mean,'Color',c_sto);
        hold on;
        semilogy(epochDet,objerrDeterministic_last,'Color',c_det);
        semilogy(epochSto,objerrStochastic_ergodic_mean,'--','Color',c_sto);
        semilogy(epochDet,objerrDeterministic_ergodic,'--','Color',c_det);
        
        title(dataName,'Interpreter','latex','FontSize',14)
        ylabel('relative objective suboptimality','Interpreter','latex','FontSize',14);
        xlabel('epoch','Interpreter','latex','FontSize',14);
        
        subplot(2,4,4+t)
        hold off
        semilogy(epochSto,feasStochastic_last_mean,'Color',c_sto);
        hold on;
        semilogy(epochDet,feasDeterministic_last,'Color',c_det);
        semilogy(epochSto,feasStochastic_ergodic_mean,'--','Color',c_sto);
        semilogy(epochDet,feasDeterministic_ergodic,'--','Color',c_det);

        title(dataName,'Interpreter','latex','FontSize',14)
        ylabel('infeasibility','Interpreter','latex','FontSize',14);
        xlabel('epoch','Interpreter','latex','FontSize',14);
        
    end
    
    for t = 1:8
        subplot(2,4,t)
        
        ax = gca;
        set(findall(ax, 'Type', 'line'),'LineWidth',2);
        ax.FontSize = 14;
        ax.TickLabelInterpreter = 'latex';
        ax.TickDir = 'out';
        set(gca,'TickDir','out')
        set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
        ax.Box = 'on';
        
        ax.YTick = 10.^(-100:100);
        ax.XTick = 0:2:100;
        ax.XMinorTick = 'on';
        ax.XRuler.MinorTickValues = 1:99; %just like major ticks
        grid on, grid minor, grid minor
        
        axis tight
        xlim([0,10])
        
    end
    
end

%%
hl = legend('Stochastic','Deterministic');
hl.Interpreter = 'latex';
hl.FontSize = 14;
hl.Location = 'NorthEast';
