import multiprocessing
import sys
import os

# Add the parent directory of the 'scheduling' module to the Python path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))
sys.path.append("/hpc/za64617/projects/GNN4APC_dev/code/src")

from routing.run_genetic_algorithm import initialize_run, run_algo


def target_runner_error(msg):
    print("target-runner.py: error: " + msg, file=sys.stderr)
    sys.exit(1)


def tune_algo(instance, seed, **config):
    parameters = {'instance_file': '/hpc/st-ds/projects/GNN4APC/za64617/cvrp_data/cvrp_100_10000.pkl',
                  'problem_instance': int(instance),
                  'nr_of_objectives': 2,
                  'population_size': 50,
                  'ngen': 50,
                  'indpb': config['indpb'],
                  'cr': config['cr'],
                  'logbook': False,
                  'plotting': False}

    population, toolbox, stats, hof = initialize_run(**parameters)
    hypervolume = run_algo(population, toolbox, None, None, stats, hof, **parameters)
    return -hypervolume


if __name__=='__main__':
    if len(sys.argv) < 5:
        print("\nUsage: ./target-runner-ga.py <configuration_id> <instance_id> <seed> <instance_name> <list of parameters>\n")
        sys.exit(1)

    # Parse command line arguments
    configuration_id = sys.argv[1]
    instance_id = sys.argv[2]
    seed = int(sys.argv[3])
    instance = sys.argv[4]
    ga_params = sys.argv[5:]

    # Parse parameters
    args = {}
    while ga_params:
        # Get and remove first and second elements.
        param = ga_params.pop(0)
        if not param.startswith("--"):
            target_runner_error(f"unknown parameter {param}")
        param = param[2:]  # Remove --
        param, value = param.split('=')

        if param in ["cr", "indpb"]:
            value = float(value)
        elif param in ["nr_objectives", "population_size", "ngen"]:
            value = int(value)
        else:
            target_runner_error(f"unknown parameter {param}")

        args[param] = value

    # Run the GA with the provided parameters
    performance_metric = tune_algo(instance, seed, **args)
    print(f'{performance_metric}\n')
    sys.exit(0)
