import os
import json
import multiprocessing
from deap import base, creator, tools

from pathlib import Path

from routing.genetic_algorithm.operators import *
from routing.helper_functions import *


folder_names = ['cvrp_500_10000.pkl']
for folder_name in folder_names:
    base_path = Path(__file__).parent.absolute()
    instance_path = base_path.joinpath(folder_name)
    problem_instances = [i for i in range(0, 100)] + [i for i in range(1000, 1100)]
    population_size = 1000

    new_reference_points = {}
    pool = multiprocessing.Pool()

    for problem_instance in problem_instances:
        nb_customers, truck_capacity, dist_matrix_data, dist_depot_data, demands_data = read_input_cvrp(
            instance_path, problem_instance)

        toolbox = base.Toolbox()
        creator.create("FitnessMin", base.Fitness, weights=(-1.0, -1.0))
        creator.create("Individual", list, fitness=creator.FitnessMin)

        toolbox.register('indexes', random.sample, range(1, nb_customers + 1), nb_customers)
        toolbox.register('individual', tools.initIterate, creator.Individual, toolbox.indexes)
        toolbox.register('population', tools.initRepeat, list, toolbox.individual)
        toolbox.register('evaluate', eval_individual_fitness, truck_capacity=truck_capacity,
                         dist_matrix_data=dist_matrix_data, dist_depot_data=dist_depot_data, demands_data=demands_data)

        initial_population = toolbox.population(n=population_size)
        fitnesses = list(map(toolbox.evaluate, initial_population))
        max_bounds = list(np.max(fitnesses, axis=0))
        new_reference_points[problem_instance] = max_bounds

    # Load existing reference points from the JSON file (if it exists)
    existing_reference_points = {}
    if os.path.isfile('/hpc/za64617/projects/GNN4APC_dev/code/src//routing/data/reference_points_500_2_obj.json'):
        with open('/hpc/za64617/projects/GNN4APC_dev/code/src//routing/data/reference_points_500_2_obj.json', 'r') as file:
            existing_reference_points = json.load(file)

    # Update the existing reference points with new ones, only adding new keys
    for key, value in new_reference_points.items():
        if key not in existing_reference_points:
            existing_reference_points[key] = value

    # Write the updated reference points back to the JSON file
    with open('/hpc/za64617/projects/GNN4APC_dev/code/src//routing/data/reference_points_500_2_obj.json', 'w') as file:
        json.dump(existing_reference_points, file)
