import os
import json
import multiprocessing

import numpy as np
from pathlib import Path

from scheduling.run_genetic_algorithm import initialize_run

folder_names = ['fajsp_sdsts/dafjs', 'fajsp_sdsts/yfjs']
for folder_name in folder_names:
    base_path = Path(__file__).parent.absolute()
    folder_path = base_path.joinpath(folder_name)
    instances = ['/' + '/'.join(folder_path.parts[-2:]) + '/' + f for f in os.listdir(folder_path) if
                 os.path.isfile(os.path.join(folder_path, f))]

    new_reference_points = {}
    pool = multiprocessing.Pool()

    for instance in instances:
        params = {"population_size": 1000, "problem_instance": instance, 'nr_of_objectives': 7}
        initial_population, toolbox, stats, hof, jobShopEnv = initialize_run(pool, **params)
        fitnesses = [ind.fitness.values for ind in initial_population]
        max_bounds = list(np.max(fitnesses, axis=0))
        new_reference_points[instance] = max_bounds

    # Load existing reference points from the JSON file (if it exists)
    existing_reference_points = {}
    if os.path.isfile('/scheduling/data/reference_points.json'):
        with open('/scheduling/data/reference_points.json', 'r') as file:
            existing_reference_points = json.load(file)

    # Update the existing reference points with new ones, only adding new keys
    for key, value in new_reference_points.items():
        if key not in existing_reference_points:
            existing_reference_points[key] = value

    # Write the updated reference points back to the JSON file
    with open('/scheduling/data/reference_points.json', 'w') as file:
        json.dump(existing_reference_points, file)
