if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi
seq_len=96
model_name=UniTST

root_path_name=./dataset/
data_path_name=PEMS04.npz
model_id_name=PEMS04
data_name=PEMS
num_router=10
d_model=512
d_ff=512
lr=0.0001
n_layers=4
dropout=0.2

random_seed=2021
for lr in 0.0001 0.0005
do
  for pred_len in 12 24 48 96
  do
    for num_router in 10
    do
      python -u run_longExp.py \
        --random_seed $random_seed \
        --is_training 1 \
        --root_path $root_path_name \
        --data_path $data_path_name \
        --model_id ${model_id_name}'_'$seq_len'_'$pred_len \
        --model $model_name \
        --data $data_name \
        --features M \
        --seq_len $seq_len \
        --pred_len $pred_len \
        --enc_in 307 \
        --e_layers ${n_layers} \
        --n_heads 16 \
        --d_model ${d_model} \
        --d_ff ${d_ff} \
        --dropout ${dropout} \
        --fc_dropout ${dropout} \
        --head_dropout 0\
        --patch_len 16\
        --stride 8\
        --des 'Exp' \
        --train_epochs 100 \
        --num_workers 10 \
        --patience 20 \
        --w_router 1 \
        --num_router $num_router \
        --itr 1 --batch_size 64 --learning_rate ${lr} | tee logs/LongForecasting/$model_name'_nrouter_'${num_router}'_'$model_id_name'_dm_'${d_model}'_dff_'${d_ff}'_nlyer'_${n_layers}'_lr_'${lr}'_dp_'${dropout}'_'$seq_len'_'$pred_len.log
    done
  done
done
