if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi
seq_len=96
model_name=UniTST

root_path_name=./dataset/
data_path_name=ETTh1.csv
model_id_name=ETTh1
data_name=ETTh1
num_router=10
d_model=64
d_ff=64
lr=0.0001
n_layers=3
dropout=0.3
patch_len=16
stride=$((patch_len/2))
batch_size=128

random_seed=2021
for pred_len in 192
do
  for num_router in 10
  do
    python -u run_longExp.py \
      --random_seed $random_seed \
      --is_training 1 \
      --root_path $root_path_name \
      --data_path $data_path_name \
      --model_id ${model_id_name}'_'$seq_len'_'$pred_len \
      --model $model_name \
      --data $data_name \
      --features M \
      --seq_len $seq_len \
      --pred_len $pred_len \
      --enc_in 7 \
      --e_layers ${n_layers} \
      --n_heads 4 \
      --d_model ${d_model} \
      --d_ff ${d_ff} \
      --dropout ${dropout}\
      --fc_dropout ${dropout}\
      --head_dropout 0\
      --patch_len ${patch_len}\
      --stride ${stride}\
      --des 'Exp' \
      --train_epochs 100 \
      --num_workers 10 \
      --w_router 1 \
      --num_router $num_router \
      --itr 1 --batch_size ${batch_size} --learning_rate ${lr}
#      | \
#      tee logs/LongForecasting/$model_name'_nrouter_'${num_router}'_'$model_id_name'_dm_'${d_model}'_dff_'${d_ff}'_nlyer'_${n_layers}'_ptchlen_'${patch_len}'_bs_'${batch_size}'_lr_'${lr}'_dp_'${dropout}'_'$seq_len'_'$pred_len.log
  done
done
