if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi
seq_len=96
model_name=UniTST

root_path_name=./dataset/
data_path_name=traffic.csv
model_id_name=traffic
data_name=custom
num_router=10
d_model=512
d_ff=512
lr=0.0001
n_layers=4
dropout=0.1
patch_len=16
stride=$((patch_len/2))
batch_size=16

random_seed=2021
for patch_len in 16 32 48 96
do
  stride=$((patch_len/2))
  for lr in 0.0001
  do
    for num_router in 10
    do
      for pred_len in 96
      do
        echo logs/LongForecasting/$model_name'_nrouter_'${num_router}'_'$model_id_name'_dm_'${d_model}'_dff_'${d_ff}'_nlyer'_${n_layers}'_ptchlen_'${patch_len}'_bs_'${batch_size}'_lr_'${lr}'_dp_'${dropout}'_'$seq_len'_'$pred_len.log
        python -u run_longExp.py \
          --random_seed $random_seed \
          --is_training 1 \
          --root_path $root_path_name \
          --data_path $data_path_name \
          --model_id ${model_id_name}'_'$seq_len'_'$pred_len \
          --model $model_name \
          --data $data_name \
          --features M \
          --seq_len $seq_len \
          --pred_len $pred_len \
          --enc_in 862 \
          --e_layers ${n_layers} \
          --n_heads 16 \
          --d_model ${d_model} \
          --d_ff ${d_ff} \
          --dropout ${dropout} \
          --fc_dropout ${dropout} \
          --head_dropout 0.1 \
          --patch_len ${patch_len} \
          --stride ${stride} \
          --des 'Exp' \
          --train_epochs 100\
          --patience 20\
          --lradj 'TST'\
          --pct_start 0.2\
          --w_router 1 \
          --num_router $num_router \
          --itr 1 --batch_size ${batch_size} --learning_rate ${lr} | \
          tee logs/LongForecasting/$model_name'_nrouter_'${num_router}'_'$model_id_name'_dm_'${d_model}'_dff_'${d_ff}'_nlyer'_${n_layers}'_ptchlen_'${patch_len}'_bs_'${batch_size}'_lr_'${lr}'_dp_'${dropout}'_'$seq_len'_'$pred_len.log
      done
    done
  done
done