import pickle
import numpy as np
import argparse
import yaml
import time

def load_config(yaml_file):
    with open(yaml_file, 'r') as file:
        config = yaml.load(file, Loader=yaml.SafeLoader)
    return config

def load_single_model_pred_result(full_path):
    with open(full_path + '_result', 'rb') as file:
        result = pickle.load(file)  
    return result['pred']

def lower_upper_probs_evaluation(dataset):
    ######### Get the Same Ensembles as Standards #########        
    with open('five_ensembles', 'rb') as file:
        DEs5 = pickle.load(file)

    full_path = 'testResSNN/' + dataset
    # full_path = 'testVggSNN/' + dataset

    preds_single_model = load_single_model_pred_result(full_path)
    preds_15 = np.stack(preds_single_model)

    # Ensemble of Five
    preds5_mod = dict()            
    probsLo = []
    probsHi = []
    for j in range(15):
        DEs5Index = DEs5[str(j)]
        preds = preds_15[DEs5Index,]
        lower_probs = np.min(preds, axis=0)
        upper_probs = np.max(preds, axis=0)
        probsLo.append(lower_probs)
        probsHi.append(upper_probs)
        
    preds5_mod['lower probs'] = np.stack(probsLo)
    preds5_mod['upper probs'] = np.stack(probsHi)
    
    return preds5_mod

def main():
    
    # Accept a YAML file as a command-line argument
    parser = argparse.ArgumentParser(description='Process parameters from a YAML file.')
    parser.add_argument('config_file', type=str, help='Path to the YAML configuration file')
    args = parser.parse_args()

    config = load_config(args.config_file)

    dataset_name = config['Dataset']

    start_time = time.time()
    
    result5 = lower_upper_probs_evaluation(dataset_name)
    
    end_time = time.time()
    
    print(end_time - start_time)
  
    # full_path = 'testResSNN_CRE/' + dataset_name
    full_path = 'testVggSNN_CRE/' + dataset_name
  
       
    with open(full_path + '_lower_upper_probs5', 'wb') as file5:
        pickle.dump(result5, file5)

if __name__ == "__main__":
    main()

    