import hydra
from openteach.components.visualizers import RobotImageVisualizer

@hydra.main(version_base = '1.2', config_path = 'configs', config_name = 'viz_camera')
def visualize_robot_image(configs):
    visualizer = RobotImageVisualizer(
        host = configs.host_address,
        cam_port_offset = configs.cam_port_offset,
        cam_id = configs.selected_cam
    )
    visualizer.stream()

if __name__ == '__main__':
    visualize_robot_image()