## Abstract

Official PyTorch implementation of AsymKV

## Usage

### Environment Setup

```bash
conda create -yn streaming python=3.10
conda activate streaming

pip install torch torchvision torchaudio
pip install transformers==4.44.2 accelerate datasets evaluate wandb scikit-learn scipy sentencepiece

python setup.py develop
```
###  evaluate on LongBench
### step 1 
Pull the LongBench code
```bash
git clone https://github.com/THUDM/LongBench
cd LongBench\LongBench
```
### step 2
Place the pred_longbench_[442|433].py files from the example folder into the LongBench\LongBench directory for evaluation
```bash
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 torchrun --nproc_per_node=8 --master_port 6656 pred_longbench_442.py --model Llama-3.1-8B-Instruct --method compress
```

## Model
Due to updates in the cache of Transformers, some models("Llama-3-series","llama2-series) need to run with transformers==4.33.0


