# Transforming Self-Supervision in Test Time for Personalizing Human Pose Estimation

This is only a draft version. A more complete codebase will be released at open source.

## Preparation
1. Install PyTorch and torchvision.
2. Install dependencies
   ```bash
   pip install -r requirements.txt
   ```
3. Make libs

    ```bash
    cd ${PROJECT_ROOT}/lib
    make
    ```
4. Place data in `data` diretory and pretrained model in `models/pytorch/imagenet` directory. We use offical pretrained model of PyTorch
   ```
   https://download.pytorch.org/models/resnet18-5c106cde.pth
   https://download.pytorch.org/models/resnet50-19c8e357.pth
   ```
5. We use original data of [Penn Action](http://dreamdragon.github.io/PennAction/) and [BBC Pose](https://www.robots.ox.ac.uk/~vgg/data/pose/). Preprocessed Human 3.6M can be found at [this link](https://drive.google.com/file/d/1TMKp1y4gE7oMLriyfRzj3h7w6xj-XnCI/view?usp=sharing).


## Baseline

We use Penn Action as examples for following instructions.

To train the baseline model
   ```bash
   python tools/train.py --cfg experiments/final/penn/res50_128x128.yaml
   ```

## Joint Training

To train the joint Transformer model
   ```bash
   python tools/train_joint.py --cfg experiments/final/penn/joint_res50_128x128_1e-3_comb_attn_tf1_4head.yaml
   ```

## Run Test-Time Personalization

You may need to modify key `MODEL_FILE` if you choose a different location for checkpoint.

   ```bash
   python tools/test_time_training.py --cfg experiments/final/penn/ttt_res50_128x128_lr1e-4_online_downsample1_comb_attn_tf1_4head.yaml
   ```

