# placeholder


### Environment:

install with following steps:
```bash
conda env create -f environment.yml
conda install -c "nvidia/label/cuda-11.8.0" cuda-toolkit
# Manually install flash attention
pip install flash-attn --no-build-isolation
# Manually install cosine annealing with warmup
pip install 'git+https://github.com/katsura-jp/pytorch-cosine-annealing-with-warmup'
# Manually install xformers
pip3 install -U xformers --index-url https://download.pytorch.org/whl/cu118
pip install deepspeed
```

### Dataset:

#### EMBED

Download at [here](https://github.com/Emory-HITI/EMBED_Open_Data)

#### RSNA-Mammo dataset

Download at [here](https://www.kaggle.com/competitions/rsna-breast-cancer-detection/overview)

### Pre-training:

To reproduce the best model, run:
```bash
python train.py  --batch_size 36 --learning_rate 4e-5 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm --devices 4 --strategy 'ddp_find_unused_parameters_true' --llm_type gpt --precision bf16-true --peft lora --accumulate_grad_batches 2 --grad_ckpt --weight_decay 0.1 --warm_up 4000 --emb_dim 512 --max_steps 40000 --linear_proj --pool_feat --embed --structural_cap --slip --img_size 518 --crop_size 518 --vit_grad_ckpt --load_jpg --raw_caption --num_workers 8 --mask_ratio 1.0 --mask_meta 0.8 --symmetric_clip --inter_side  --local_contrast --pool_txt_feat --late_loss 8000 --symmetric_local  --num_freeze_blocks 0
```

### Zero-shot:

To reproduce the zero-shot evaluation, run:
```bash
python train.py  --batch_size 36 --learning_rate 4e-5 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm --devices 4 --strategy 'ddp_find_unused_parameters_true' --llm_type gpt --precision bf16-true --peft lora --accumulate_grad_batches 2 --grad_ckpt --weight_decay 0.1 --warm_up 4000 --emb_dim 512 --max_steps 40000 --linear_proj --pool_feat --embed --structural_cap --slip --img_size 518 --crop_size 518 --vit_grad_ckpt --load_jpg --raw_caption --num_workers 8 --mask_ratio 1.0 --mask_meta 0.8 --symmetric_clip --inter_side  --local_contrast --pool_txt_feat --late_loss 8000 --symmetric_local  --num_freeze_blocks 0 --pretrained_model <pre-trained-model> --num_classes 7 --balanced_test --instance_test_cap --eval --ten_pct
python train.py  --batch_size 36 --learning_rate 4e-5 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm --devices 4 --strategy 'ddp_find_unused_parameters_true' --llm_type gpt --precision bf16-true --peft lora --accumulate_grad_batches 2 --grad_ckpt --weight_decay 0.1 --warm_up 4000 --emb_dim 512 --max_steps 40000 --linear_proj --pool_feat --embed --structural_cap --slip --img_size 518 --crop_size 518 --vit_grad_ckpt --load_jpg --raw_caption --num_workers 8 --mask_ratio 1.0 --mask_meta 0.8 --symmetric_clip --inter_side  --local_contrast --pool_txt_feat --late_loss 8000 --symmetric_local  --num_freeze_blocks 0 --pretrained_model <pre-trained-model> --num_classes 4 --balanced_test --instance_test_cap --eval --pred_density --ten_pct
python train.py  --batch_size 36 --learning_rate 4e-5 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm --devices 4 --strategy 'ddp_find_unused_parameters_true' --llm_type gpt --precision bf16-true --peft lora --accumulate_grad_batches 2 --grad_ckpt --weight_decay 0.1 --warm_up 4000 --emb_dim 512 --max_steps 40000 --linear_proj --pool_feat --rsna_mammo --structural_cap --slip --img_size 518 --crop_size 518 --vit_grad_ckpt --load_jpg --raw_caption --num_workers 8 --mask_ratio 1.0 --mask_meta 0.8 --symmetric_clip --inter_side  --local_contrast --pool_txt_feat --late_loss 8000 --symmetric_local  --num_freeze_blocks 0 --pretrained_model <pre-trained-model> --num_classes 2 --instance_test_cap --eval
```

### Fine-tuning
To evaluate the models under linear classification settings, run
```bash
python train.py  --batch_size 36 --learning_rate 5e-4 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm_ft --devices 2 --strategy 'ddp_find_unused_parameters_true' --precision bf16-true --weight_decay 1e-3 --warm_up 100 --emb_dim 512 --max_steps 8000 --linear_proj --pool_feat --embed --structural_cap --vit_grad_ckpt --slip --inter_side --img_size 518 --crop_size 518 --raw_caption --load_jpg --symmetric_clip --num_freeze_blocks 0 --local_contrast --pool_txt_feat --symmetric_local --sgd --min_lr 1e-5 --pretrained_encoder <pre-trained-model> --num_classes 7 --img_cls_ft --balance_training --balanced_test --freeze_vit
python train.py  --batch_size 36 --learning_rate 5e-4 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm_ft_density --devices 2 --strategy 'ddp_find_unused_parameters_true' --precision bf16-true --weight_decay 1e-3 --warm_up 100 --emb_dim 512 --max_steps 8000 --linear_proj --pool_feat --embed --structural_cap --vit_grad_ckpt --slip --inter_side --img_size 518 --crop_size 518 --raw_caption --load_jpg --symmetric_clip --num_freeze_blocks 0 --sgd --local_contrast --pool_txt_feat --symmetric_local --min_lr 1e-5 --pretrained_encoder <pre-trained-model> --num_classes 4 --img_cls_ft --balance_training --balanced_test --freeze_vit --pred_density
python train.py  --batch_size 36 --learning_rate 5e-4 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm_ft_rsna_tune --devices 2 --strategy 'ddp_find_unused_parameters_true' --precision bf16-true --weight_decay 1e-3 --warm_up 100 --emb_dim 512 --max_steps 8000 --linear_proj --pool_feat --rsna_mammo --structural_cap --vit_grad_ckpt --slip --inter_side --img_size 518 --crop_size 518 --raw_caption --load_jpg --symmetric_clip --num_freeze_blocks 0 --sgd --local_contrast --pool_txt_feat --symmetric_local --min_lr 1e-5 --pretrained_encoder <pre-trained-model> --img_cls_ft --balance_training --freeze_vit
```

To evaluate the model under full fine-tune settings, run
```bash
python train.py  --batch_size 36 --learning_rate 5e-4 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm_fft --devices 2 --strategy 'ddp_find_unused_parameters_true' --precision bf16-true --weight_decay 1e-3 --warm_up 100 --emb_dim 512 --max_steps 8000 --linear_proj --pool_feat --embed --structural_cap --vit_grad_ckpt --slip --inter_side --img_size 518 --crop_size 518 --raw_caption --load_jpg --symmetric_clip --num_freeze_blocks 0 --local_contrast --pool_txt_feat --symmetric_local --sgd --min_lr 1e-5 --pretrained_encoder <pre-trained-model> --num_classes 7 --img_cls_ft --balance_training --balanced_test
python train.py  --batch_size 36 --learning_rate 5e-4 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm_fft_density --devices 2 --strategy 'ddp_find_unused_parameters_true' --precision bf16-true --weight_decay 1e-3 --warm_up 100 --emb_dim 512 --max_steps 8000 --linear_proj --pool_feat --embed --structural_cap --vit_grad_ckpt --slip --inter_side --img_size 518 --crop_size 518 --raw_caption --load_jpg --symmetric_clip --num_freeze_blocks 0 --sgd --local_contrast --pool_txt_feat --symmetric_local --min_lr 1e-5 --pretrained_encoder <pre-trained-model> --num_classes 4 --img_cls_ft --balance_training --balanced_test --pred_density
python train.py  --batch_size 36 --learning_rate 5e-4 --experiment_name lora_gpt_structural_simclr_side_symm_local_symm_fft_rsna --devices 2 --strategy 'ddp_find_unused_parameters_true' --precision bf16-true --weight_decay 1e-3 --warm_up 100 --emb_dim 512 --max_steps 8000 --linear_proj --pool_feat --rsna_mammo --structural_cap --vit_grad_ckpt --slip --inter_side --img_size 518 --crop_size 518 --raw_caption --load_jpg --symmetric_clip --num_freeze_blocks 0 --sgd --local_contrast --pool_txt_feat --symmetric_local --min_lr 1e-5 --pretrained_encoder <pre-trained-model> --img_cls_ft --balance_training
```
