# Code for "The third pillar of causal analysis? A measurement perspective on causal representations"

## Numerical Simulation

The simulation experiment in section 5.1 employs the multi-view CRL algorithm by 
[1]. 

### Installation of Multi-View CRL with Partial Observability
<p align="left">
    <a href="https://www.python.org/downloads/"><img alt="Python" src="https://img.shields.io/badge/python-3.11-blue.svg"></a>
    <a href="https://pytorch.org/get-started/"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-2.1.0-orange.svg"></a>
    <a href="https://black.readthedocs.io/en/stable/"><img alt="Code style: black" src="https://img.shields.io/ba#ge/code%20style-black-000000.svg"></a>
    <a href="https://mamba.readthedocs.io/en/latest/"><img alt="virtualenv" src="https://img.shields.io/badge/virtualenv-mamba-pink.svg"></a>
</p>

```shell
cd numerical_simulation/
mamba env create -f env.yaml
mamba activate crl_venv
pre-commit install
```

### To reproduce the results 
```shell
# train
python main_numerical.py --model-id "five_latents_a" --n-steps 50001 --seed 858
python main_numerical.py --model-id "five_latents_b" --n-steps 51 --seed 134 

# evaluate
python main_numerical.py --model-id "five_latents_a" --evaluate --seed 426
python main_numerical.py --model-id "five_latents_b" --evaluate --seed 680
python eval_numerical.py 
```



## Real-world Ecological Experiment: ISTAnt

The script `istant/run_rex.py` provide the code to run the Experiment on real-ecology data, as described in Section 5.2 and Appendix D.2, on top of ISTAnt official repository [https://github.com/CausalLearningAI/ISTAnt ](https://github.com/CausalLearningAI/ISTAnt) [2]. Different encoder and head classifiers can be considered modifying the hyper-parameters and training details. 



## References
[1] Yao, D., Xu, D., Lachapelle, S., Magliacane, S., Taslakian, P., Martius, G., von Kügelgen, J. and Locatello, F., "Multi-view causal representation learning with partial observability." In Proc. 12th Int. Conf. Learn. Representations (ICLR), Vienna, Austria, 2024

[2] Cadei, R., Lindorfer, L., Cremer, S., Schmid, C., & Locatello, F. (2024). Smoke and mirrors in causal downstream tasks. Advances in Neural Information Processing Systems, 37, 26082-26112.