

# Installation instructions

To run the code in this project, first, create a Python virtual environment using e.g. Conda:

```shell
conda create -n sal python=3.11 && conda activate sal
```

```shell
pip install -e '.[dev]'
```

Next, log into your Hugging Face account as follows:

```shell
huggingface-cli login
```

Finally, install Git LFS so that you can push models to the Hugging Face Hub:

```shell
sudo apt-get install git-lfs
```

You can now check out the `scripts` and `recipes` directories for instructions on how to scale test-time compute for open models!

# Run experiments

First, ```cd search-and-learn``` and run the scripts in the folder ```experiment_scripts```.


Note that you might have to set the visible CUDA devices to match the attention head. For example, ```export CUDA_VISIBLE_DEVICES=0,1,2,3,5,6,7,8,9,10,11``` to match the number of attention heads (12). 

Then, the results are saved in ```./output```. 

