#!/bin/bash

echo "Running Llama-3.2-1B-Instruct, using Beam Search search strategy"
echo "Make sure that the OUTPUT_DIR exists before running this script."

export CONFIG=recipes/Qwen-2.5-Math-7B-Instruct/beam_search.yaml
# export PRM=RLHFlow/Llama3.1-8B-PRM-Deepseek-Data
export PRM=Skywork/Skywork-o1-Open-PRM-Qwen-2.5-1.5B
export OUTPUT_DIR=./output/granularity_B2_tradeoff

# Check if the directories exist, if not create them
if [ ! -d "$OUTPUT_DIR" ]; then
    echo "Creating OUTPUT_DIR: $OUTPUT_DIR"
    mkdir -p "$OUTPUT_DIR"
fi


B1=16
B2_list=(2 4 6 8)
g_list=(1 2 3 4)
num_iterations_list=(12 6 4 3)

echo "Running test_time_compute.py with different g and B2 values"

for j in {0..3}
do  
    g=${g_list[$j]}
    B2=${B2_list[$j]}
    num_iterations=${num_iterations_list[$j]}
    n=$((B1 * B2))
    echo "Running test_time_compute.py with n=$n, g=$g, B1=$B1, B2=$B2, num_iterations=$num_iterations"
    dir_path="$OUTPUT_DIR/Qwen-2.5-Math-7B-Instruct-Skywork-o1-1.5B-PRM-g${g}-B1-${B1}-B2-${B2}-I-${num_iterations}"
    # Check if the directory exists, if not create it
    if [ ! -d "$dir_path" ]; then
        mkdir -p "$dir_path"
        echo "Directory $dir_path created."
    else
        echo "Directory $dir_path already exists."
    fi
    LOG_FILE="$dir_path/log.log"

    python scripts/test_time_compute.py $CONFIG \
        --n=$n \
        --num_samples=500 \
        --prm_path=$PRM \
        --output_dir=$dir_path \
        --seed=0 \
        --lookahead=0 \
        --num_iterations=$num_iterations \
        --g=$g \
        --beam_width=$B2 > "$LOG_FILE" 2>&1

    echo "Test Time Compute completed for n=$n, g=$g, B1=$B1, B2=$B2, num_iterations=$num_iterations. Check $LOG_FILE for details."
done


