echo "Running test_time_compute.py with different PRM models and g for n=4,16,64,128"

export CONFIG=recipes/Qwen-2.5-Math-7B-Instruct/beam_search.yaml
export PRM_1_5B=Skywork/Skywork-o1-Open-PRM-Qwen-2.5-1.5B
export PRM_7B=Skywork/Skywork-o1-Open-PRM-Qwen-2.5-7B
export OUTPUT_DIR=./output/granularity_PV_tradeoff
export SEED=0

n=16

EXPERIMENT_TWO_1_5B_DIR="$OUTPUT_DIR/Skywork-o1-1_5B_n${n}_g1"
mkdir -p "$EXPERIMENT_TWO_1_5B_DIR"
LOG_FILE="$EXPERIMENT_TWO_1_5B_DIR/log.log"
python scripts/test_time_compute.py $CONFIG \
    --n=$n \
    --num_samples=500 \
    --prm_path=$PRM_1_5B \
    --output_dir=$EXPERIMENT_TWO_1_5B_DIR \
    --seed=$SEED \
    --lookahead=0 \
    --num_iterations=12 \
    --g=1 > "$LOG_FILE" 2>&1

echo "Test Time Compute completed for n=$n, PRM_1.5B. Check $LOG_FILE for details."

EXPERIMENT_TWO_7B_DIR="$OUTPUT_DIR/Skywork-o1-7B_n${n}_g2"
mkdir -p "$EXPERIMENT_TWO_7B_DIR"
LOG_FILE="$EXPERIMENT_TWO_7B_DIR/log.log"
python scripts/test_time_compute.py $CONFIG \
    --n=$n \
    --num_samples=500 \
    --prm_path=$PRM_7B \
    --output_dir=$EXPERIMENT_TWO_7B_DIR \
    --seed=$SEED \
    --lookahead=0 \
    --num_iterations=6 \
    --g=2 > "$LOG_FILE" 2>&1

echo "Test Time Compute completed for n=$n, PRM_7B. Check $LOG_FILE for details."
