#!/bin/bash

echo "Make sure that the OUTPUT_DIR exists before running this script."

export SMALL_POLICY_MODEL=recipes/Qwen-2.5-Math-1.5B-Instruct/best_of_n.yaml
export LARGE_POLICY_MODEL=recipes/Qwen-2.5-Math-7B-Instruct/best_of_n.yaml
export SMALL_PRM=Skywork/Skywork-o1-Open-PRM-Qwen-2.5-1.5B
export LARGE_PRM=Skywork/Skywork-o1-Open-PRM-Qwen-2.5-7B
export EXPERIMENT_DIR=./output/generator_verifier_tradeoff/best-of-n

if [ ! -d "$EXPERIMENT_DIR" ]; then
    echo "Creating EXPERIMENT_DIR: $EXPERIMENT_DIR"
    mkdir -p "$EXPERIMENT_DIR"
else
    echo "Directory $EXPERIMENT_DIR already exists."
fi

export SEED=0
max_iterations=12
system_prompt="Please reason step by step, and put your final answer within \\boxed{}."

echo "Running test_time_compute.py with different policy models and PRM models"

n=128

echo "Running test_time_compute.py with n=$n"

small_policy_output_dir="$EXPERIMENT_DIR/Qwen2.5-1_5B-Skywork-o1-7B-n${n}"
small_policy_log_file="$small_policy_output_dir/log.log"
large_policy_output_dir="$EXPERIMENT_DIR/Qwen2.5-7B-Skywork-o1-1_5B-n${n}"
large_policy_log_file="$large_policy_output_dir/log.log"

if [ ! -d "$small_policy_output_dir" ]; then
    echo "Creating small policy output directory: $small_policy_output_dir"
    mkdir -p "$small_policy_output_dir"
else
    echo "Directory $small_policy_output_dir already exists."
fi
if [ ! -d "$large_policy_output_dir" ]; then
    echo "Creating large policy output directory: $large_policy_output_dir"
    mkdir -p "$large_policy_output_dir"
else
    echo "Directory $large_policy_output_dir already exists."
fi

python scripts/test_time_compute.py $SMALL_POLICY_MODEL \
    --n=$n \
    --num_samples=1 \
    --prm_path=$LARGE_PRM \
    --output_dir=$small_policy_output_dir \
    --system_prompt="$system_prompt" \
    --seed=$SEED \
    --lookahead=0 \
    --num_iterations=$max_iterations > "$small_policy_log_file" 2>&1

python scripts/test_time_compute.py $LARGE_POLICY_MODEL \
    --n=$n \
    --num_samples=1 \
    --prm_path=$SMALL_PRM \
    --output_dir=$large_policy_output_dir \
    --system_prompt="$system_prompt" \
    --seed=$SEED \
    --lookahead=0 \
    --num_iterations=$max_iterations > "$large_policy_log_file" 2>&1

echo "Test Time Compute completed. Check log files in $EXPERIMENT_DIR"
