export TASK_NAME=personality
export DATA_DIR=cls_v4
export model=7b-chat
export prefix=edit
export method_type=ike

CUDA_VISIBLE_DEVICES=1 python run_cls.py \
  --model_name_or_path ./cls \
  --task_name $TASK_NAME \
  --do_eval \
  --do_predict \
  --train_file ./generation/${model}_${method_type}_${prefix}_cls.json\
  --validation_file ./generation/${model}_${method_type}_${prefix}_cls.json \
  --test_file ./generation/${model}_${method_type}_${prefix}_cls.json \
  --max_seq_length 128 \
  --per_device_train_batch_size 16 \
  --per_device_eval_batch_size 16 \
  --learning_rate 2e-5 \
  --num_train_epochs 1 \
  --output_dir ./output/generation/${model}/${method_type}/${prefix} \
  --overwrite_output


  #  eval_accuracy           =     0.2965
  # eval_loss               =     4.8518
  # eval_runtime            = 0:00:01.38
  # eval_samples            =        199
  # eval_samples_per_second =     143.22
  # eval_steps_per_second   =      9.356

  #   eval_accuracy           =       0.58
  # eval_loss               =     1.4412
  # eval_runtime            = 0:00:01.16
  # eval_samples            =        200
  # eval_samples_per_second =    172.009
  # eval_steps_per_second   =     11.181