import numpy as np
import pandas as pd
import random
from sklearn import linear_model, tree, svm, ensemble
from sklearn.neural_network import MLPRegressor
from sklearn.metrics import mean_squared_error, r2_score, mean_absolute_error
from xgboost import XGBRegressor
import torch
import torch.nn as nn





# prediction model
class PredModel(nn.Module):
    def __init__(self, input_size, output_size):
        super(PredModel, self).__init__()
        self.reg = nn.Sequential(
            nn.Linear(input_size, input_size*2),
            nn.LeakyReLU(),
            # nn.Dropout(0.1),
            nn.Linear(input_size*2, output_size*2),
            nn.LeakyReLU(),
            # nn.Dropout(0.1),
            nn.Linear(output_size*2, output_size),
            nn.LeakyReLU(),
            # nn.Dropout(0.1),
            nn.Linear(output_size, output_size)
        )

    def forward(self, x):
        x = self.reg(x)
        return x
