import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
from mpl_toolkits import mplot3d


COLOR_TABLE = {
    "green": [0.4, 0.87, 0.58, 1],
    "yellow": [1, 0.66, 0, 1],
    "red": [1, 0.38, 0.43, 0.8],
}

class PlotTrace(object):
    def __init__(self, grid_size=10):
        self.fig = plt.figure()
        self.ax = self.fig.add_subplot(111, projection='3d')
        self.axes = [grid_size] * 3

    def animate(self, frame):
        plt.cla()
        stuff = self.trace[frame]
        for s in stuff:
            color, pos = s
            colors = np.empty(self.axes + [4], dtype=np.float32)
            colors[:] = COLOR_TABLE[color]
            enc_pos = np.zeros(self.axes)
            enc_pos[pos[0], pos[1], pos[2]] = 1
            self.ax.voxels(enc_pos, facecolors=colors, edgecolors=[0.91, 0.94, 0.95, 1])
        return self.ax

    def plot(self, trace, count=0):
        self.trace = trace
        trace_len = len(self.trace)
        anim = FuncAnimation(self.fig, self.animate, frames=trace_len)
        file_name = f'./trace_{count}.gif'
        anim.save(file_name, writer='pillow')
        print("gif saved!")
        # plt.show()


def test():
    p = PlotTrace()
    p.plot(
        [
            [['green', [1, 2, 0]], ['green', [1, 2, 0]]],
            [['red', [1, 3, 0]], ['green', [2, 2, 0]]],
            [['green', [2, 3, 0]], ['yellow', [1, 2, 0]]],
        ]
    )


if __name__ == "__main__":
    test()
