class Buff(object):
    def __init__(self, name="", value=0.0, initial_time=999, myself=True, now_time=0):
        self.name = name
        self.initial_value = value
        self.value = value
        self.initial_time = initial_time
        self.now_time = now_time
        self.myself = myself

    def refresh(self):
        if self.now_time > 0:
            self.now_time -= 1


class TankBuffs(object):
    def __init__(self):
        self.buff_list = [
            Buff(name="0攻击力数值上升（摄提·伐）", value=646.0, initial_time=30),
            Buff(name="1减防加攻（破军斩）", value=0.31, initial_time=15),
            Buff(name="2持续伤害（流火·炎）", initial_time=7, myself=False),
            Buff(name="3攻击力百分比降低（司怪·困）", value=0.37, initial_time=30, myself=False),
            Buff(name="4免疫（轩辕·守）", value=1, initial_time=3),
            Buff(name="5防御力数值上升（轩辕·守）", value=2750.0, initial_time=15),
            Buff(name="6减受到伤害（轩辕·守）", value=0.06, initial_time=6),
            Buff(name="7攻击力百分比降低（天寿·忍）", value=0.7, initial_time=4),
            Buff(name="8减受到伤害（天寿·忍）", value=0.6, initial_time=4),

            # 给敌人加眩晕buff，value为成功概率
            Buff(name="9眩晕（虎贲·冲）", value=0.442, initial_time=3, myself=False),
            Buff(name="10眩晕（贯索·擒）", value=0.62, initial_time=5, myself=False),

            Buff(name="11攻击力百分比降低（河鼓·震）", value=0.7, initial_time=25, myself=False),

            Buff(name="12光环（青龙·灭）", initial_time=7),
            Buff(name="13攻击力数值上升（青龙·灭）", value=5148.0, initial_time=2),
            Buff(name="14防御力数值降低（青龙·灭）", value=4200.0, initial_time=10, myself=False),
            Buff(name="15伤害计算公式（时间）", value=-0.1, now_time=999),
            Buff(name="16攻击力百分比上升（时间）", value=0.0, now_time=999),

            # from shooter
            Buff(name="17持续伤害（流火）", value=0.36, initial_time=15, myself=False),
            Buff(name="18持续伤害（蝎毒透骨）", initial_time=7, myself=False),
            Buff(name="19持续伤害（蝎尾）", initial_time=7, myself=False),
            Buff(name="20持续伤害（烽火四起）", initial_time=6, myself=False),
            Buff(name="21持续伤害（羿射九日）", value=0.36, initial_time=15, myself=False),
            Buff(name="22持续伤害（万虫蚀体）", initial_time=7, myself=False),

            Buff(name="23沉默（百步穿杨）", initial_time=7, myself=False),
            Buff(name="24减速（箭雨流星）", value=0.783, initial_time=22, myself=False),

            Buff(name="25眩晕（心弦）", value=0.32, initial_time=3, myself=False),
        ]

    def get_buffs(self):
        return self.buff_list


class ShooterBuffs(object):
    def __init__(self):
        self.buff_list = [
            # for self and from shooters
            Buff(name="0持续伤害（流火）", value=0.36, initial_time=15, myself=False),
            Buff(name="1不能自动释放羿射九日（流火）", initial_time=10),
            Buff(name="2持续伤害（蝎毒透骨）", initial_time=7, myself=False),
            Buff(name="3持续伤害（蝎尾）", initial_time=7, myself=False),
            Buff(name="4持续伤害（烽火四起）", initial_time=6, myself=False),
            Buff(name="5持续伤害（羿射九日）", value=0.36, initial_time=15, myself=False),
            Buff(name="6持续伤害（万虫蚀体）", initial_time=7, myself=False),

            Buff(name="7眩晕（心弦）", value=0.32, initial_time=3, myself=False),
            Buff(name="8吟唱（百步穿杨）", initial_time=1),
            Buff(name="9箭塔（万箭阵）"),
            Buff(name="10沉默（百步穿杨）", initial_time=7, myself=False),
            Buff(name="11引导（箭雨流星）", initial_time=3),
            Buff(name="12减速（箭雨流星）", value=0.783, initial_time=22, myself=False),
            Buff(name="13伤害计算公式（时间）", value=-0.13, now_time=999),
            Buff(name="14攻击力百分比上升（时间）", value=0.0, now_time=999),

            # from tank
            Buff(name="15防御力数值降低（青龙·灭）", value=4200.0, initial_time=10, myself=False),
            Buff(name="16持续伤害（流火·炎）", initial_time=7, myself=False),
            Buff(name="17攻击力百分比降低（司怪·困）", value=0.37, initial_time=30, myself=False),
            Buff(name="18眩晕（虎贲·冲）", value=0.442, initial_time=3, myself=False),
            Buff(name="19眩晕（贯索·擒）", value=0.62, initial_time=5, myself=False),
            Buff(name="20攻击力百分比降低（河鼓·震）", value=0.7, initial_time=25, myself=False),
        ]

    def get_buffs(self):
        return self.buff_list


# class FangShiBuffs(object):
#     def __init__(self):
#         self.buff_list = [
#             Buff(name="0持续伤害（祝融指路）", initial_time=7, myself=False),
#             Buff(name="1引导（地火诀）", initial_time=3),
#             Buff(name="2增伤（地火诀）", value=1, initial_time=2, myself=False),
#             Buff(name="3引导（天火焚原）", initial_time=3),
#             Buff(name="4增伤（天火焚原）", value=1, initial_time=3, myself=False),
#             Buff(name="5引导（天雷诀）", initial_time=3),
#             Buff(name="6增伤（天雷诀）", value=1, initial_time=2, myself=False),
#             Buff(name="7引导（雷动九天）", initial_time=3),
#             Buff(name="8增伤（雷动九天）", value=1, initial_time=3, myself=False),
#             Buff(name="9持续伤害（天雨涤凡）", initial_time=6),
#             Buff(name="10持续伤害（风卷尘生）", initial_time=6),
#             Buff(name="11减伤（逍遥游）", value=0.55, initial_time=10),
#             Buff(name="12加防（腹语真言）", value=0.13, initial_time=5),
#             Buff(name="13加攻（腹语真言）", value=4050.0, initial_time=10),
#             Buff(name="14减伤（腹语真言）", value=0.35, initial_time=10),
#             Buff(name="15引导（飘风振海）", initial_time=5),
#             Buff(name="16引导（雷火无妄）", initial_time=5),
#             Buff(name="17减速（雷火无妄）", value=0.783, initial_time=22, myself=False),
#             Buff(name="18伤害计算公式（时间）", value=-0.2, now_time=999),
#             Buff(name="19攻击力百分比上升（时间）", value=0.0, now_time=999),
#         ]
#
#     def get_buffs(self):
#         return self.buff_list
