class Skill(object):
    def __init__(
        self,
        name,
        damage=0.0,
        initial_cd=0.0,
        buff_id=[],
        e1=0.0,
        e2=0.0,
        distance=99.0,
        carry=False,
    ):
        self.name = name
        self.initial_damage = damage
        self.damage = damage
        self.initial_cd = initial_cd
        self.now_cd = 0
        self.buff_id = buff_id
        self.e1 = e1
        self.e2 = e2
        self.distance = distance
        self.carry = carry

    def refresh(self):
        if self.now_cd > 0:
            self.now_cd -= 1
        if self.now_cd < 0:
            self.now_cd = 0


class TankSkills(object):
    def __init__(self):
        self.skill_list = [
            # for self and from tank
            Skill(name="0近战物攻", distance=2.5, e1=1.0, damage=1.0, initial_cd=1, carry=True),
            Skill(name="1摄提·伐，自身攻击力数值上升", distance=2.5, e1=1.0, e2=1458.0, damage=1.0, buff_id=[0], initial_cd=1),
            Skill(name="2七杀·旋", distance=5.0, e1=0.56, e2=2137.0, damage=1.0, initial_cd=1),
            Skill(name="3破军·斩，自身减防加攻", distance=2.5, e1=1.05, e2=6273.0, damage=1.0, buff_id=[1], initial_cd=1),
            Skill(name="4流火·炎，对敌人造成伤害，并给敌人加持续伤害的buff", distance=3.0, e1=0.72, e2=4402.0, damage=1.3, buff_id=[2], initial_cd=5),
            Skill(name="5贪狼·双", distance=2.5, e1=0.8, e2=6954.0, damage=2.0, initial_cd=1),
            Skill(name="6司怪·困，敌人攻击力百分比降低", distance=3.0, buff_id=[3], initial_cd=5),
            Skill(name="7轩辕·守，debuff clean", buff_id=[4, 5, 6], initial_cd=90.0),
            Skill(name="8天寿·忍，debuff clean", distance=6.0, e1=1.0, e2=5519.0, damage=1.0, buff_id=[7, 8], initial_cd=40),
            Skill(name="9虎贲·冲，撞过去+自身攻击力数值上升+敌人眩晕", distance=8.0,  e1=1.0, e2=2574.0, damage=1.35, buff_id=[0, 9], initial_cd=12),
            Skill(name="10贯索·擒，把敌人拉过来+敌人眩晕", distance=8.0, buff_id=[10], initial_cd=12),
            Skill(name="11河鼓·震，敌人攻击力百分比降低", distance=5.0, buff_id=[11], initial_cd=120),
            Skill(name="12青龙·灭，自身光环+攻击力数值上升", buff_id=[12, 13], initial_cd=210),
            Skill(name="13远离", carry=True),
            Skill(name="14靠近", carry=True),
            Skill(name="15发呆", carry=True),
            Skill(name="16流火·炎（持续伤害），每步给敌人造成的伤害", e1=0.72, e2=4402.0, damage=0.26, carry=True),
            Skill(name="17青龙·灭（光环伤害），敌人防御力数值降低", distance=12.0, e1=1.0, e2=4902.0, damage=1.0, buff_id=[14], carry=True),
        ]

    def get_skills(self):
        return self.skill_list


class ShooterSkills(object):
    def __init__(self):
        self.skill_list = [
            # for self and from shooter
            Skill(name="0远程物攻", distance=8.0, e1=1.0, damage=1.0, initial_cd=0, carry=True),
            Skill(name="1流火", distance=8.0, e1=1.0, e2=1917.0, damage=1.28, buff_id=[0], initial_cd=0.7),
            Skill(name="2蝎毒透骨", distance=8.0, e1=0.7, e2=1559.0, damage=1.0, buff_id=[2], initial_cd=1),
            Skill(name="3蝎尾", distance=8.0, e1=1.0, e2=1971.0, damage=1.0, buff_id=[3], initial_cd=1),
            Skill(name="4烽火四起", distance=7.0, buff_id=[4], initial_cd=8),
            Skill(name="5羿射九日", distance=7.0, e1=0.7, e2=2867.0, damage=1.0, buff_id=[5], initial_cd=5),
            Skill(name="6万虫蚀体", distance=8.0, e1=0.7, e2=4640.0, damage=1.0, buff_id=[6], initial_cd=5),
            Skill(name="7凝霜", distance=8.0, e1=0.7, e2=1275.0, damage=0.9, initial_cd=1),
            Skill(name="8心弦", distance=8.0, e1=1.4, e2=2867.0, damage=1.0, buff_id=[7], initial_cd=8),
            Skill(name="9万箭阵", buff_id=[9], initial_cd=5),
            Skill(name="10孤注一掷", distance=4.0, e1=0.7, e2=6916.0, damage=1.0, initial_cd=1),
            Skill(name="11冰天雪窑", distance=7.0, e1=0.7, e2=1676.0, damage=0.8, initial_cd=5),
            Skill(name="12拒人千里", initial_cd=15),
            Skill(name="13百步穿杨（吟唱）", buff_id=[8], initial_cd=120),
            Skill(name="14箭雨流星", buff_id=[11], initial_cd=210),
            Skill(name="15远离", carry=True),
            Skill(name="16靠近", carry=True),
            Skill(name="17发呆", carry=True),

            # 每步给敌人造成的伤害
            Skill(name="18流火（持续伤害）", e1=1.0, e2=1917.0, damage=0.062, carry=True),
            Skill(name="19蝎毒透骨（持续伤害）", e1=0.7, e2=1559.0, damage=0.08175, carry=True),
            Skill(name="20蝎尾（持续伤害）", e1=0.6, e2=869.0, damage=0.8175, carry=True),
            Skill(name="21烽火四起（持续伤害）", e1=0.4, e2=1844.0, damage=0.7325, carry=True),
            Skill(name="22羿射九日（持续伤害）", e1=0.7, e2=2867.0, damage=0.1, carry=True),
            Skill(name="23万虫蚀体（持续伤害）", e1=0.7, e2=4640.0, damage=0.08175, carry=True),
            # Skill(name='24箭塔（光环伤害）', distance=8., e1=0.6, e2=1200., damage=1., carry=True),
            Skill(name="24箭塔（光环伤害）", distance=8.0, carry=True),
            Skill(name="25箭雨流星（光环伤害1）", distance=10.0, e1=0.8, e2=11383.0, damage=1.0, carry=True),
            Skill(name="26箭雨流星（光环伤害2）", distance=10.0, e1=0.7, e2=7968.0, damage=0.75, buff_id=[12], carry=True),
            Skill(name="27百步穿杨（发动）", distance=10.0, e1=1.45, e2=8449.0, damage=1.0, buff_id=[10], initial_cd=120, carry=True),
        ]

    def get_skills(self):
        return self.skill_list


# class FangShiSkills(object):
#     def __init__(self):
#         self.skill_list = [
#             Skill(
#                 name="0远程物攻", distance=8, e1=0.5, damage=1.0, initial_cd=1, carry=True
#             ),
#             Skill(
#                 name="1火符咒", distance=8, e1=1.0, e2=3251.0, damage=0.68, initial_cd=0.7
#             ),
#             Skill(
#                 name="2祝融指路",
#                 distance=8,
#                 e1=0.7,
#                 e2=1814.0,
#                 damage=0.68,
#                 buff_id=[0],
#                 initial_cd=1,
#             ),
#             Skill(name="3地火诀", buff_id=[1], initial_cd=2),
#             Skill(name="4天火焚原", buff_id=[3], initial_cd=5),
#             Skill(
#                 name="5星流电驰", distance=8, e1=1.0, e2=3675.0, damage=0.865, initial_cd=1
#             ),
#             Skill(name="6天雷诀", buff_id=[5], initial_cd=2),
#             Skill(name="7雷动九天", buff_id=[7], initial_cd=5),
#             Skill(
#                 name="8冰符咒", distance=8, e1=1.0, e2=2281.0, damage=0.469, initial_cd=1
#             ),
#             Skill(name="9天雨涤凡", distance=7, buff_id=[9], initial_cd=8),
#             Skill(
#                 name="10霜锋乱舞", distance=7, e1=0.7, e2=2846.0, damage=0.625, initial_cd=5
#             ),
#             Skill(name="11风卷尘生", distance=7, buff_id=[10], initial_cd=8),
#             Skill(
#                 name="12箕风远扬", distance=7, e1=0.7, e2=4067.0, damage=0.59, initial_cd=5
#             ),
#             Skill(name="13逍遥游", buff_id=[11], initial_cd=40),
#             Skill(name="14腹语真言", buff_id=[12, 13, 14], initial_cd=75),
#             Skill(name="15飘风振海", buff_id=[15], initial_cd=210),
#             Skill(name="16雷火无妄", buff_id=[16], initial_cd=210),
#             Skill(name="17远离", carry=True),
#             Skill(name="18靠近", carry=True),
#             Skill(name="19发呆", carry=True),
#             Skill(name="20祝融指路（持续伤害）", e1=0.7, e2=1814.0, damage=0.068, carry=True),
#             Skill(
#                 name="21地火诀（引导）",
#                 distance=9,
#                 e1=1.13,
#                 e2=7124.0,
#                 damage=0.68,
#                 buff_id=[2],
#                 carry=True,
#             ),
#             Skill(
#                 name="22天火焚原（引导）",
#                 distance=7,
#                 e1=0.7,
#                 e2=5616.0,
#                 damage=0.68,
#                 buff_id=[4],
#                 carry=True,
#             ),
#             Skill(
#                 name="23天雷诀（引导）",
#                 distance=9,
#                 e1=1.05,
#                 e2=9564.0,
#                 damage=0.865,
#                 buff_id=[6],
#                 carry=True,
#             ),
#             Skill(
#                 name="24雷动九天（引导）",
#                 distance=7,
#                 e1=0.8,
#                 e2=6970.0,
#                 damage=0.865,
#                 buff_id=[8],
#                 carry=True,
#             ),
#             Skill(name="25天雨涤凡（持续伤害）", e1=0.5, e2=1200.0, damage=0.625, carry=True),
#             Skill(name="26风卷尘生（持续伤害）", e1=0.7, e2=3196.0, damage=0.59, carry=True),
#             Skill(
#                 name="27飘风镇海（引导）", distance=12, e1=1, e2=6190.0, damage=0.59, carry=True
#             ),
#             Skill(
#                 name="28雷火无妄（引导1）",
#                 distance=12,
#                 e1=0.9,
#                 e2=12815.0,
#                 damage=0.865,
#                 carry=True,
#             ),
#             Skill(
#                 name="29雷火无妄（引导2）",
#                 distance=12,
#                 e1=0.9,
#                 e2=12815.0,
#                 damage=0.625,
#                 buff_id=[17],
#                 carry=True,
#             ),
#         ]
#
#     def get_skills(self):
#         return self.skill_list
